<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        $months = [
            'january', 'february', 'march', 'april', 'may', 'june',
            'july', 'august', 'september', 'october', 'november', 'december'
        ];

        // Create 12 monthly tables for Regent
        foreach ($months as $month) {
            Schema::create("{$month}_regent", function (Blueprint $table) {
                $table->id();
                $table->string('Business_Unit', 50)->nullable();
                $table->string('Room', 10)->nullable()->index();
                $table->string('RoomType', 50)->nullable()->index();
                $table->date('Posting_Date')->nullable()->index();
                $table->string('Guest_Full_Name')->nullable();
                $table->string('Market_Code', 50)->nullable()->index();
                $table->string('TRX_Code', 20)->nullable()->index();
                $table->string('TRX_Desc')->nullable();
                $table->decimal('Amount_1', 15, 2)->nullable();
                $table->string('Interval', 10)->nullable();
                $table->string('No_Asset', 50)->nullable();
                $table->bigInteger('Row_No')->nullable();
                $table->string('odata_etag')->nullable();
                $table->timestamps();
                
                // Composite index for common queries
                $table->index(['Room', 'Posting_Date']);
                $table->index(['Market_Code', 'Posting_Date']);
                $table->index(['TRX_Code', 'Amount_1']);
            });
        }

        // Create OOO table for Regent
        Schema::create('ooo_regent', function (Blueprint $table) {
            $table->id();
            $table->string('Business_Unit', 50)->nullable();
            $table->string('Room_No', 10)->nullable()->index();
            $table->string('Room_Class', 50)->nullable();
            $table->date('Begin_Date')->nullable()->index();
            $table->date('Completed_On')->nullable()->index();
            $table->string('Reason_Desc')->nullable();
            $table->text('Repair_Remark')->nullable();
            $table->bigInteger('AuxiliaryIndex1')->nullable();
            $table->string('odata_etag')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        $months = [
            'january', 'february', 'march', 'april', 'may', 'june',
            'july', 'august', 'september', 'october', 'november', 'december'
        ];

        foreach ($months as $month) {
            Schema::dropIfExists("{$month}_regent");
        }

        Schema::dropIfExists('ooo_regent');
    }
};