<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        $months = [
            'january', 'february', 'march', 'april', 'may', 'june',
            'july', 'august', 'september', 'october', 'november', 'december'
        ];

        foreach ($months as $month) {
            Schema::table("{$month}_regent", function (Blueprint $table) {
                $table->string('Room', 50)->change(); // Dari VARCHAR(10) ke VARCHAR(50)
            });
        }

        // Update OOO table juga
        Schema::table('ooo_regent', function (Blueprint $table) {
            $table->string('Room_No', 50)->change();
        });
    }

    public function down(): void
    {
        $months = [
            'january', 'february', 'march', 'april', 'may', 'june',
            'july', 'august', 'september', 'october', 'november', 'december'
        ];

        foreach ($months as $month) {
            Schema::table("{$month}_regent", function (Blueprint $table) {
                $table->string('Room', 10)->change();
            });
        }

        Schema::table('ooo_regent', function (Blueprint $table) {
            $table->string('Room_No', 10)->change();
        });
    }
};