<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        $months = [
            'january', 'february', 'march', 'april', 'may', 'june',
            'july', 'august', 'september', 'october', 'november', 'december'
        ];

        foreach ($months as $month) {
            Schema::table("{$month}_regent", function (Blueprint $table) {
                $table->decimal('Amount_1', 20, 2)->change();
            });
        }
    }

    public function down(): void
    {
        $months = [
            'january', 'february', 'march', 'april', 'may', 'june',
            'july', 'august', 'september', 'october', 'november', 'december'
        ];

        foreach ($months as $month) {
            Schema::table("{$month}_regent", function (Blueprint $table) {
                $table->decimal('Amount_1', 15, 2)->change();
            });
        }
    }
};