@extends('layouts.hirbnd')

@section('title', 'Suite - ' . $roomTypeName)
@section('page-title', $roomTypeName)

@push('styles')
<style>
    .rooms-grid {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(280px, 1fr));
        gap: 20px;
        margin-top: 24px;
    }

    .room-card {
        background: white;
        border-radius: 12px;
        padding: 20px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
        transition: all 0.3s ease;
        border: 2px solid transparent;
        position: relative;
        overflow: hidden;
    }

    .room-card::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 4px;
        background: linear-gradient(90deg, #667eea, #764ba2);
    }

    .room-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 6px 20px rgba(118, 75, 162, 0.3);
        border-color: #764ba2;
    }

    .room-number {
        font-size: 32px;
        font-weight: 700;
        color: #764ba2;
        margin-bottom: 12px;
    }

    .room-status {
        display: inline-block;
        padding: 6px 12px;
        background: #28a745;
        color: white;
        border-radius: 20px;
        font-size: 12px;
        font-weight: 600;
        margin-bottom: 12px;
    }

    .room-type-badge {
        display: inline-block;
        padding: 6px 12px;
        background: linear-gradient(135deg, #667eea, #764ba2);
        color: white;
        border-radius: 6px;
        font-size: 12px;
        font-weight: 600;
        margin-bottom: 16px;
    }

    .btn-view-details {
        width: 100%;
        padding: 10px;
        background: linear-gradient(135deg, #667eea, #764ba2);
        color: white;
        border: none;
        border-radius: 8px;
        font-weight: 600;
        text-decoration: none;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 8px;
        transition: all 0.3s ease;
    }

    .btn-view-details:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(118, 75, 162, 0.4);
        color: white;
    }

    .page-header {
        margin-bottom: 24px;
        padding-bottom: 16px;
        border-bottom: 2px solid #f0f0f0;
    }

    .breadcrumb {
        background: none;
        padding: 0;
        margin: 0;
    }

    .breadcrumb-item + .breadcrumb-item::before {
        content: "›";
        color: #6c757d;
    }

    .room-count-badge {
        background: linear-gradient(135deg, #667eea, #764ba2);
        color: white;
        padding: 8px 16px;
        border-radius: 20px;
        font-size: 14px;
        font-weight: 600;
    }
    .breadcrumb-custom {
        display: flex;
        align-items: center;
        gap: 8px;
        font-size: 14px;
        margin-top: 8px;
    }

    .breadcrumb-link {
        color: #6c757d;
        text-decoration: none;
        transition: color 0.3s ease;
    }

    .breadcrumb-link:hover {
        color: #764ba2;
    }

    .breadcrumb-separator {
        color: #adb5bd;
        font-weight: 300;
    }

    .breadcrumb-current {
        color: #764ba2;
        font-weight: 600;
    }
    .suite-icon {
        position: absolute;
        top: 12px;
        right: 12px;
        color: #ffd700;
        font-size: 20px;
    }
</style>
@endpush

@section('content')
<div class="container-fluid">
    <!-- Page Header -->
    <div class="page-header">
        <div class="d-flex justify-content-between align-items-center flex-wrap">
            <div class="mb-3 mb-md-0">
                <h2 class="mb-2" style="color: #764ba2; font-weight: 700;">
                    <i class="fas fa-crown me-2" style="color: #ffd700;"></i>{{ $roomTypeName }}
                </h2>
                <div class="breadcrumb-custom">
                    <a href="{{ route('hirbnd.dashboard') }}" class="breadcrumb-link">
                        <i class="fas fa-home"></i> Dashboard
                    </a>
                    <span class="breadcrumb-separator">›</span>
                    <a href="{{ route('hirbnd.suite') }}" class="breadcrumb-link">
                        Suite Rooms
                    </a>
                    <span class="breadcrumb-separator">›</span>
                    <span class="breadcrumb-current">{{ $roomType }}</span>
                </div>
            </div>
            <div>
                <span class="room-count-badge">
                    <i class="fas fa-crown me-2"></i>{{ count($rooms) }} Rooms
                </span>
            </div>
        </div>
    </div>

    <!-- Rooms Grid -->
    <div class="rooms-grid">
        @forelse($rooms as $room)
        <div class="room-card">
            <i class="fas fa-gem suite-icon"></i>
            <div class="room-number">{{ $room }}</div>
            <div class="room-status">
                <i class="fas fa-check-circle me-1"></i>Available
            </div>
            <div class="room-type-badge">
                <i class="fas fa-crown me-1"></i>{{ $roomType }}
            </div>
            <a href="{{ route('hirbnd.suite.room-matrix', ['roomType' => $roomType, 'room' => $room]) }}" 
               class="btn-view-details">
                <i class="fas fa-chart-bar"></i>
                View Details
            </a>
        </div>
        @empty
        <div class="col-12">
            <div class="alert alert-warning">
                <i class="fas fa-exclamation-triangle me-2"></i>
                No rooms found for this room type. Please load data first.
            </div>
        </div>
        @endforelse
    </div>

    <!-- Back Button -->
    <div class="mt-4">
        <a href="{{ route('hirbnd.suite') }}" class="btn btn-outline-secondary">
            <i class="fas fa-arrow-left me-2"></i>Back to Suite Rooms
        </a>
    </div>
</div>
@endsection