@extends('layouts.regent')

@section('title', $submenuName)

@push('styles')
<style>
    .submenu-header {
        background: linear-gradient(135deg, #00897b, #26a69a);
        color: white;
        border-radius: 12px;
        padding: 32px;
        margin-bottom: 32px;
    }

    .submenu-header h2 {
        font-size: 32px;
        margin-bottom: 8px;
    }

    .breadcrumb {
        display: flex;
        gap: 8px;
        align-items: center;
        margin-bottom: 24px;
        font-size: 14px;
    }

    .breadcrumb a {
        color: #00897b;
        text-decoration: none;
        font-weight: 600;
    }

    .breadcrumb a:hover {
        text-decoration: underline;
    }

    .breadcrumb span {
        color: #999;
    }

    .submenu-tabs {
        background: white;
        border-radius: 12px;
        padding: 16px;
        margin-bottom: 24px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
        display: flex;
        gap: 12px;
        flex-wrap: wrap;
    }

    .submenu-tab {
        padding: 12px 24px;
        border-radius: 8px;
        text-decoration: none;
        color: #666;
        font-weight: 600;
        transition: all 0.3s;
        border: 2px solid transparent;
    }

    .submenu-tab:hover {
        background: #e8f5e9;
        color: #00897b;
    }

    .submenu-tab.active {
        background: linear-gradient(135deg, #00897b, #26a69a);
        color: white;
    }

    .rooms-grid {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(200px, 1fr));
        gap: 20px;
    }

    .room-card {
        background: white;
        border-radius: 12px;
        padding: 24px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
        transition: all 0.3s;
        text-decoration: none;
        color: inherit;
        text-align: center;
        border: 2px solid transparent;
    }

    .room-card:hover {
        transform: translateY(-4px);
        box-shadow: 0 8px 20px rgba(0, 137, 123, 0.2);
        border-color: #00897b;
    }

    .room-number {
        font-size: 28px;
        font-weight: 700;
        color: #00897b;
        margin-bottom: 8px;
    }

    .room-icon {
        font-size: 32px;
        color: #26a69a;
        margin-bottom: 12px;
    }

    .room-label {
        font-size: 13px;
        color: #666;
    }
</style>
@endpush

@section('content')
    <!-- Breadcrumb -->
<div class="breadcrumb">
    <a href="{{ route('regent.rooms') }}"><i class="fas fa-home"></i> Room Categories</a>
    <span>/</span>
    <a href="{{ route('regent.rooms.type', $roomType) }}">{{ $roomTypeName }}</a>
    <span>/</span>
    <span>{{ $submenuName }}</span>
</div>

    <!-- Submenu Header -->
    <div class="submenu-header">
        <h2><i class="fas fa-hotel"></i> {{ $submenuName }}</h2>
        <p>{{ count($rooms) }} rooms available</p>
    </div>

    <!-- Submenu Tabs -->
    <div class="submenu-tabs">
        @if($roomType === 'suite')
            {{-- Suite Tabs (GW A, B, C, D) --}}
            <a href="{{ route('regent.rooms.suite.submenu', ['submenu' => 'suite_gw_a']) }}" 
               class="submenu-tab {{ $submenu === 'suite_gw_a' ? 'active' : '' }}">
                Suite GW A
            </a>
            <a href="{{ route('regent.rooms.suite.submenu', ['submenu' => 'suite_gw_b']) }}" 
               class="submenu-tab {{ $submenu === 'suite_gw_b' ? 'active' : '' }}">
                Suite GW B
            </a>
            <a href="{{ route('regent.rooms.suite.submenu', ['submenu' => 'suite_gw_c']) }}" 
               class="submenu-tab {{ $submenu === 'suite_gw_c' ? 'active' : '' }}">
                Suite GW C
            </a>
            <a href="{{ route('regent.rooms.suite.submenu', ['submenu' => 'suite_gw_d']) }}" 
               class="submenu-tab {{ $submenu === 'suite_gw_d' ? 'active' : '' }}">
                Suite GW D
            </a>
        @elseif($roomType === 'corner_suite')
            {{-- Corner Suite Tabs (GW C, GW D) --}}
            <a href="{{ route('regent.rooms.corner.submenu', ['submenu' => 'corner_gw_c']) }}" 
               class="submenu-tab {{ $submenu === 'corner_gw_c' ? 'active' : '' }}">
                Corner Suite GW C
            </a>
            <a href="{{ route('regent.rooms.corner.submenu', ['submenu' => 'corner_gw_d']) }}" 
               class="submenu-tab {{ $submenu === 'corner_gw_d' ? 'active' : '' }}">
                Corner Suite GW D
            </a>
        @endif
    </div>

    <!-- Rooms Grid -->
    <div class="rooms-grid">
        @foreach($rooms as $room)
            @if($roomType === 'suite')
                {{-- Suite Room Card --}}
                <a href="{{ route('regent.rooms.suite.matrix', ['submenu' => $submenu, 'room' => $room]) }}" class="room-card">
                    <div class="room-icon">
                        <i class="fas fa-bed"></i>
                    </div>
                    <div class="room-number">{{ $room }}</div>
                    <div class="room-label">View Matrix</div>
                </a>
            @elseif($roomType === 'corner_suite')
                {{-- Corner Suite Room Card --}}
                <a href="{{ route('regent.rooms.corner.matrix', ['submenu' => $submenu, 'room' => $room]) }}" class="room-card">
                    <div class="room-icon">
                        <i class="fas fa-bed"></i>
                    </div>
                    <div class="room-number">{{ $room }}</div>
                    <div class="room-label">View Matrix</div>
                </a>
            @endif
        @endforeach
    </div>
@endsection