<?php

use App\Http\Controllers\Hirbnd\DashboardController;
use App\Http\Controllers\Hirbnd\StandardController;
use App\Http\Controllers\Hirbnd\SuiteController;
use App\Http\Controllers\Hirbnd\ManageDataController;
use App\Http\Controllers\Hirbnd\ReportController;
use Illuminate\Support\Facades\Route;

// HIRBND Routes with prefix /hirbnd
Route::prefix('hirbnd')->name('hirbnd.')->middleware('auth')->group(function () {
    
    // Dashboard (skip CheckDataLoaded middleware)
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');

    // Manage Data (skip CheckDataLoaded middleware)
    Route::get('/manage-data', [ManageDataController::class, 'index'])->name('manage-data');
    Route::post('/manage-data/refresh', [ManageDataController::class, 'refreshData'])->name('manage-data.refresh');

    // Routes yang butuh data loaded
    Route::middleware('check.data.loaded')->group(function () {
        
        // Standard Rooms
        Route::get('/standard', [StandardController::class, 'index'])->name('standard');
        Route::get('/standard/{roomType}', [StandardController::class, 'showRoomType'])->name('standard.room-type');
        Route::get('/standard/{roomType}/{room}', [StandardController::class, 'showRoomMatrix'])->name('standard.room-matrix');

        // Suite Rooms
        Route::get('/suite', [SuiteController::class, 'index'])->name('suite');
        Route::get('/suite/{roomType}', [SuiteController::class, 'showRoomType'])->name('suite.room-type');
        Route::get('/suite/{roomType}/{room}', [SuiteController::class, 'showRoomMatrix'])->name('suite.room-matrix');

        // Reports - Detail Room (harus sebelum routes reports utama!)
        Route::prefix('reports')->name('reports.')->group(function () {
            // OOO Room Detail - BARU!
            Route::get('/ooo/room/{room}', [ReportController::class, 'oooRoomDetail'])->name('ooo.room');
            
            // Detail per room - existing
            Route::get('/house-use/room/{room}', [ReportController::class, 'houseUseRoomDetail'])->name('house-use.room');
            Route::get('/complimentary/room/{room}', [ReportController::class, 'complimentaryRoomDetail'])->name('complimentary.room');
            
            // Reports utama
            Route::get('/house-use', [ReportController::class, 'houseUse'])->name('house-use');
            Route::get('/complimentary', [ReportController::class, 'complimentary'])->name('complimentary');
            Route::get('/ooo', [ReportController::class, 'ooo'])->name('ooo');
            Route::get('/revenue', [ReportController::class, 'revenue'])->name('revenue');
        });
    });
});