

<?php $__env->startSection('title', 'Out of Order Report'); ?>

<?php $__env->startPush('styles'); ?>
<style>
    /* ===== STICKY HEADER WITH FILTER & STATS ===== */
    .report-sticky-header {
        position: sticky;
        top: 70px;
        z-index: 100;
        background: white;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        border-radius: 12px;
        margin-bottom: 24px;
    }

    .header-content {
        background: linear-gradient(135deg, #0ea5e9, #0284c7);
        color: white;
        border-radius: 12px 12px 0 0;
        padding: 24px 32px;
    }

    .header-top {
        display: flex;
        justify-content: space-between;
        align-items: start;
        margin-bottom: 20px;
    }

    .header-title h2 {
        font-size: 28px;
        margin-bottom: 4px;
        font-weight: 700;
    }

    .header-title p {
        font-size: 14px;
        opacity: 0.95;
    }

    .header-filter {
        display: flex;
        gap: 12px;
        align-items: center;
        background: rgba(255, 255, 255, 0.15);
        padding: 12px 16px;
        border-radius: 8px;
        backdrop-filter: blur(10px);
    }

    .header-filter label {
        font-size: 13px;
        font-weight: 600;
        margin-right: 8px;
        white-space: nowrap;
    }

    .header-filter select {
        padding: 8px 16px;
        border: 2px solid rgba(255, 255, 255, 0.3);
        border-radius: 6px;
        font-size: 13px;
        background: white;
        color: #333;
        min-width: 150px;
        font-weight: 600;
    }

    .header-filter select:focus {
        outline: none;
        border-color: white;
    }

    .btn-header {
        padding: 8px 20px;
        border: none;
        border-radius: 6px;
        font-weight: 600;
        cursor: pointer;
        font-size: 13px;
        transition: all 0.3s;
        display: flex;
        align-items: center;
        gap: 8px;
    }

    .btn-export {
        background: #28a745;
        color: white;
    }

    .btn-export:hover {
        background: #218838;
        transform: translateY(-2px);
    }

    /* ===== STICKY STATS BAR ===== */
    .stats-bar {
        display: grid;
        grid-template-columns: repeat(4, 1fr);
        gap: 1px;
        background: #e0e0e0;
        border-radius: 0 0 12px 12px;
        overflow: hidden;
    }

    .stat-item {
        background: white;
        padding: 16px 20px;
        text-align: center;
    }

    .stat-item:first-child {
        border-radius: 0 0 0 12px;
    }

    .stat-item:last-child {
        border-radius: 0 0 12px 0;
    }

    .stat-label {
        font-size: 11px;
        color: #6c757d;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        margin-bottom: 6px;
        font-weight: 600;
    }

    .stat-value {
        font-size: 24px;
        font-weight: 700;
        color: #0ea5e9;
    }

    /* ===== MATRIX TABLE WITH STICKY HEADER ===== */
    .matrix-container {
        background: white;
        border-radius: 12px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
        overflow: hidden;
    }

    .matrix-scroll-wrapper {
        overflow: auto;
        max-height: calc(100vh - 400px);
        position: relative;
    }

    .matrix-table {
        width: 100%;
        border-collapse: collapse;
        font-size: 13px;
        min-width: 1000px;
    }

    .matrix-table thead {
        position: sticky;
        top: 0;
        z-index: 10;
    }

    .matrix-table th {
        background: #0ea5e9;
        color: white;
        padding: 12px 8px;
        text-align: center;
        font-weight: 600;
        border: 1px solid #0284c7;
        white-space: nowrap;
    }

    .matrix-table th.total-header {
        background: #ffa726;
        color: #000;
        font-size: 11px;
        padding: 8px 4px;
        font-weight: 700;
    }

    .matrix-table th:first-child {
        position: sticky;
        left: 0;
        z-index: 11;
        min-width: 140px;
        text-align: left;
        padding-left: 20px;
    }

    .matrix-table td {
        padding: 12px 8px;
        text-align: center;
        border: 1px solid #e0e0e0;
    }

    .matrix-table tbody tr:hover {
        background: #f8f9fa;
    }

    .matrix-table td.room-cell {
        position: sticky;
        left: 0;
        background: #f8f9fa;
        font-weight: 600;
        text-align: left;
        padding-left: 20px;
        z-index: 9;
        border-right: 2px solid #0ea5e9;
        cursor: pointer;
    }

    .matrix-table tbody tr:hover td.room-cell {
        background: #dbeafe;
        color: #0284c7;
    }

    .matrix-table td.ooo {
        background: #ffccbc;
        color: #bf360c;
        font-weight: 600;
    }

    .matrix-table td.ooo i {
        color: #ff5722;
        font-size: 16px;
    }

    .matrix-table td.no-data {
        background: #f8f9fa;
        color: #dee2e6;
        font-weight: 600;
    }

    /* ===== EMPTY STATE ===== */
    .empty-state {
        text-align: center;
        padding: 80px 20px;
        color: #6c757d;
    }

    .empty-state i {
        font-size: 64px;
        margin-bottom: 20px;
        color: #0ea5e9;
    }

    .empty-state h3 {
        font-size: 20px;
        margin-bottom: 8px;
        color: #495057;
    }

    .empty-state p {
        font-size: 14px;
    }

    .room-class-badge {
        font-size: 10px;
        color: #6c757d;
        font-weight: normal;
        margin-left: 6px;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <?php
        // ✅ LOGIKA DATA TIDAK DIUBAH - TETAP SAMA!
        // Process OOO data for matrix
        if($month === 'all') {
            // All months view: Room x Month
            $rooms = [];
            $monthlyOOO = [];
            
            foreach($oooData as $ooo) {
                $rooms[$ooo->Room_No] = $ooo->Room_Class ?? 'GENERIC';
                
                // Get month from Begin_Date
                $beginMonth = strtolower(date('F', strtotime($ooo->Begin_Date)));
                
                if(!isset($monthlyOOO[$ooo->Room_No][$beginMonth])) {
                    $monthlyOOO[$ooo->Room_No][$beginMonth] = 0;
                }
                $monthlyOOO[$ooo->Room_No][$beginMonth]++;
            }
            
            // Calculate totals per month
            $monthTotals = [];
            foreach(['january', 'february', 'march', 'april', 'may', 'june', 'july', 'august', 'september', 'october', 'november', 'december'] as $monthName) {
                $monthTotals[$monthName] = 0;
                foreach($monthlyOOO as $roomData) {
                    $monthTotals[$monthName] += $roomData[$monthName] ?? 0;
                }
            }
            
        } else {
            // Single month view: Room x Day
            $rooms = [];
            $dailyOOO = [];
            
            foreach($oooData as $ooo) {
                $beginMonth = strtolower(date('F', strtotime($ooo->Begin_Date)));
                
                // Only show OOO that started in selected month
                if($beginMonth === $month) {
                    $rooms[$ooo->Room_No] = $ooo->Room_Class ?? 'GENERIC';
                    $day = (int) date('d', strtotime($ooo->Begin_Date));
                    
                    if(!isset($dailyOOO[$ooo->Room_No][$day])) {
                        $dailyOOO[$ooo->Room_No][$day] = 0;
                    }
                    $dailyOOO[$ooo->Room_No][$day]++;
                }
            }
            
            // Calculate totals per day
            $dayTotals = [];
            $daysInMonth = cal_days_in_month(CAL_GREGORIAN, date('n', strtotime($month)), 2025);
            for($day = 1; $day <= $daysInMonth; $day++) {
                $dayTotals[$day] = 0;
                foreach($dailyOOO as $roomData) {
                    $dayTotals[$day] += $roomData[$day] ?? 0;
                }
            }
        }
    ?>

    <!-- STICKY HEADER: Title + Filter + Stats -->
    <div class="report-sticky-header">
        <!-- Header Content with Filter -->
        <div class="header-content">
            <div class="header-top">
                <div class="header-title">
                    <h2><i class="fas fa-tools"></i> Out of Order Report</h2>
                    <p>Track rooms that are currently out of order and unavailable</p>
                </div>

                <form method="GET" action="<?php echo e(route('hirbnd.reports.ooo')); ?>" class="header-filter">
                    <label for="monthFilter"><i class="fas fa-calendar-alt"></i> Period:</label>
                    <select id="monthFilter" name="month" onchange="this.form.submit()">
                        <option value="all" <?php echo e($month === 'all' ? 'selected' : ''); ?>>All Months</option>
                        <option value="january" <?php echo e($month === 'january' ? 'selected' : ''); ?>>January</option>
                        <option value="february" <?php echo e($month === 'february' ? 'selected' : ''); ?>>February</option>
                        <option value="march" <?php echo e($month === 'march' ? 'selected' : ''); ?>>March</option>
                        <option value="april" <?php echo e($month === 'april' ? 'selected' : ''); ?>>April</option>
                        <option value="may" <?php echo e($month === 'may' ? 'selected' : ''); ?>>May</option>
                        <option value="june" <?php echo e($month === 'june' ? 'selected' : ''); ?>>June</option>
                        <option value="july" <?php echo e($month === 'july' ? 'selected' : ''); ?>>July</option>
                        <option value="august" <?php echo e($month === 'august' ? 'selected' : ''); ?>>August</option>
                        <option value="september" <?php echo e($month === 'september' ? 'selected' : ''); ?>>September</option>
                        <option value="october" <?php echo e($month === 'october' ? 'selected' : ''); ?>>October</option>
                        <option value="november" <?php echo e($month === 'november' ? 'selected' : ''); ?>>November</option>
                        <option value="december" <?php echo e($month === 'december' ? 'selected' : ''); ?>>December</option>
                    </select>

                    <button type="button" onclick="exportToExcel()" class="btn-header btn-export">
                        <i class="fas fa-file-excel"></i> Export
                    </button>
                </form>
            </div>
        </div>

        <!-- Stats Bar (Sticky with Header) -->
        <div class="stats-bar">
            <div class="stat-item">
                <div class="stat-label"><i class="fas fa-exclamation-triangle"></i> Total OOO</div>
                <div class="stat-value"><?php echo e(number_format($stats['total'])); ?></div>
            </div>

            <div class="stat-item">
                <div class="stat-label"><i class="fas fa-bed"></i> Standard</div>
                <div class="stat-value"><?php echo e(number_format($stats['standard'])); ?></div>
            </div>

            <div class="stat-item">
                <div class="stat-label"><i class="fas fa-crown"></i> Suite</div>
                <div class="stat-value"><?php echo e(number_format($stats['suite'])); ?></div>
            </div>

            <div class="stat-item">
                <div class="stat-label"><i class="fas fa-percentage"></i> OOO Rate</div>
                <div class="stat-value"><?php echo e(number_format(($stats['total'] / config('businesscentral.hirbnd.total_rooms', 366)) * 100, 1)); ?>%</div>
            </div>
        </div>
    </div>

    <!-- MATRIX TABLE with Sticky Header & Sticky First Column -->
    <div class="matrix-container">
        <?php if(count($rooms) === 0): ?>
            <div class="empty-state">
                <i class="fas fa-check-circle"></i>
                <h3>No Rooms Out of Order</h3>
                <p>All rooms are currently operational for <?php echo e($month === 'all' ? 'all months' : ucfirst($month)); ?>.</p>
            </div>
        <?php else: ?>
            <div class="matrix-scroll-wrapper">
                <?php if($month === 'all'): ?>
                    
                    <table class="matrix-table">
                        <thead>
                            <tr>
                                <th rowspan="2">Room</th>
                                <?php $__currentLoopData = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $monthName): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <th><?php echo e($monthName); ?></th>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tr>
                            <tr>
                                <?php $__currentLoopData = ['january', 'february', 'march', 'april', 'may', 'june', 'july', 'august', 'september', 'october', 'november', 'december']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $monthName): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <th class="total-header"><?php echo e($monthTotals[$monthName]); ?></th>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $rooms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $room => $roomClass): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td class="room-cell" onclick="window.location.href='/hirbnd/reports/ooo/room/<?php echo e($room); ?>'">
                                        Room <?php echo e($room); ?>

                                        <span class="room-class-badge">(<?php echo e($roomClass); ?>)</span>
                                    </td>
                                    <?php $__currentLoopData = ['january', 'february', 'march', 'april', 'may', 'june', 'july', 'august', 'september', 'october', 'november', 'december']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $monthName): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            $count = $monthlyOOO[$room][$monthName] ?? 0;
                                        ?>
                                        <?php if($count > 0): ?>
                                            <td class="ooo"><i class="fas fa-times-circle"></i></td>
                                        <?php else: ?>
                                            <td class="no-data">-</td>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                <?php else: ?>
                    
                    <?php
                        $daysInMonth = cal_days_in_month(CAL_GREGORIAN, date('n', strtotime($month)), 2025);
                    ?>
                    
                    <table class="matrix-table">
                        <thead>
                            <tr>
                                <th rowspan="2">Room</th>
                                <?php for($day = 1; $day <= $daysInMonth; $day++): ?>
                                    <th><?php echo e($day); ?></th>
                                <?php endfor; ?>
                            </tr>
                            <tr>
                                <?php for($day = 1; $day <= $daysInMonth; $day++): ?>
                                    <th class="total-header"><?php echo e($dayTotals[$day]); ?></th>
                                <?php endfor; ?>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $rooms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $room => $roomClass): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td class="room-cell" onclick="window.location.href='/hirbnd/reports/ooo/room/<?php echo e($room); ?>'">
                                        Room <?php echo e($room); ?>

                                        <span class="room-class-badge">(<?php echo e($roomClass); ?>)</span>
                                    </td>
                                    <?php for($day = 1; $day <= $daysInMonth; $day++): ?>
                                        <?php
                                            $count = $dailyOOO[$room][$day] ?? 0;
                                        ?>
                                        <?php if($count > 0): ?>
                                            <td class="ooo"><i class="fas fa-times-circle"></i></td>
                                        <?php else: ?>
                                            <td class="no-data">-</td>
                                        <?php endif; ?>
                                    <?php endfor; ?>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                <?php endif; ?>
            </div>
        <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    function exportToExcel() {
        alert('Excel export feature coming soon!');
    }
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.hirbnd', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\room-monitoring-revenue\resources\views/hirbnd/reports/ooo.blade.php ENDPATH**/ ?>