<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo $__env->yieldContent('title'); ?> - Holiday Inn Resort Bali Canggu</title>
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Inter', sans-serif;
            background: #f5f7fa;
            color: #333;
            transition: all 0.3s ease;
        }

        /* Navbar - LAVENDER THEME */
        .navbar {
            background: linear-gradient(135deg, #D3D3FF, #B8B8FF);
            color: #333;
            padding: 0 32px;
            height: 70px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            box-shadow: 0 2px 12px rgba(211, 211, 255, 0.3);
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            z-index: 1000;
            transition: all 0.3s ease;
        }

        .navbar-left {
            display: flex;
            align-items: center;
            gap: 24px;
        }

        /* Toggle Button */
        .toggle-btn {
            background: rgba(255, 255, 255, 0.5);
            border: none;
            width: 45px;
            height: 45px;
            border-radius: 10px;
            color: #333;
            font-size: 20px;
            cursor: pointer;
            transition: all 0.3s;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .toggle-btn:hover {
            background: rgba(255, 255, 255, 0.7);
        }

        .navbar-brand {
            display: flex;
            align-items: center;
            gap: 16px;
            font-size: 20px;
            font-weight: 700;
        }

        .navbar-brand .brand-icon {
            width: 48px;
            height: 48px;
            background: rgba(255, 255, 255, 0.5);
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 24px;
            color: #9494E8;
        }

        .navbar-brand .brand-text {
            display: flex;
            flex-direction: column;
            gap: 2px;
        }

        .navbar-brand .brand-name {
            font-size: 18px;
            font-weight: 700;
            letter-spacing: 0.5px;
            color: #333;
        }

        .navbar-brand .brand-subtitle {
            font-size: 10px;
            opacity: 0.8;
            font-weight: 500;
            letter-spacing: 1px;
            color: #555;
        }

        .navbar-actions {
            display: flex;
            gap: 16px;
            align-items: center;
        }

        .user-badge {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 10px 20px;
            background: rgba(255, 255, 255, 0.5);
            border-radius: 10px;
            backdrop-filter: blur(10px);
        }

        .user-badge i {
            font-size: 20px;
            color: #9494E8;
        }

        .user-badge span {
            font-size: 14px;
            font-weight: 600;
            color: #333;
        }

        .btn-logout {
            background: rgba(255, 255, 255, 0.5);
            color: #333;
            border: none;
            padding: 10px 20px;
            border-radius: 10px;
            cursor: pointer;
            font-weight: 600;
            font-size: 14px;
            transition: all 0.3s;
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .btn-logout:hover {
            background: rgba(255, 255, 255, 0.7);
        }

        .btn-companies {
            background: rgba(255, 255, 255, 0.5);
            color: #333;
            border: none;
            padding: 10px 20px;
            border-radius: 10px;
            cursor: pointer;
            font-weight: 600;
            font-size: 14px;
            transition: all 0.3s;
            display: flex;
            align-items: center;
            gap: 8px;
            text-decoration: none;
        }

        .btn-companies:hover {
            background: rgba(255, 255, 255, 0.7);
            color: #333;
        }

        /* Sidebar - LAVENDER THEME */
        .sidebar {
            width: 280px;
            background: #D3D3FF;
            min-height: calc(100vh - 70px);
            box-shadow: 2px 0 12px rgba(0, 0, 0, 0.1);
            position: fixed;
            left: 0;
            top: 70px;
            overflow-y: auto;
            z-index: 999;
            transition: all 0.3s ease;
        }

        .sidebar.collapsed {
            width: 70px;
        }

        .sidebar.collapsed .sidebar-menu a span,
        .sidebar.collapsed .sidebar-title {
            opacity: 0;
            visibility: hidden;
            width: 0;
        }

        .sidebar.collapsed .sidebar-menu a {
            justify-content: center;
            padding: 14px 10px;
        }

        .sidebar.collapsed .sidebar-menu a i {
            margin: 0;
        }

        .sidebar-menu {
            list-style: none;
            padding: 12px 0;
        }

        .sidebar-menu li {
            margin-bottom: 2px;
        }

        .sidebar-menu a {
            display: flex;
            align-items: center;
            gap: 14px;
            padding: 14px 20px;
            color: #333;
            text-decoration: none;
            transition: all 0.3s;
            font-weight: 500;
            font-size: 14px;
            position: relative;
            white-space: nowrap;
        }

        .sidebar-menu a span {
            transition: all 0.3s;
        }

        .sidebar-menu a:hover {
            background: rgba(148, 148, 232, 0.2);
            color: #000;
        }

        .sidebar-menu a.active {
            background: rgba(148, 148, 232, 0.3);
            color: #000;
            font-weight: 600;
            border-left: 4px solid #9494E8;
        }

        .sidebar-menu a i {
            font-size: 18px;
            width: 24px;
            text-align: center;
            transition: all 0.3s;
            color: #9494E8;
        }

        .sidebar-divider {
            height: 1px;
            background: rgba(148, 148, 232, 0.2);
            margin: 16px 20px;
            transition: all 0.3s;
        }

        .sidebar.collapsed .sidebar-divider {
            margin: 16px 10px;
        }

        .sidebar-title {
            padding: 12px 20px;
            font-size: 11px;
            font-weight: 700;
            color: #9494E8;
            text-transform: uppercase;
            letter-spacing: 1px;
            transition: all 0.3s;
            white-space: nowrap;
        }

        /* Main Content */
        .main-content {
            margin-left: 280px;
            margin-top: 70px;
            padding: 32px;
            min-height: calc(100vh - 70px);
            transition: all 0.3s ease;
        }

        .main-content.expanded {
            margin-left: 70px;
        }

        /* Alerts */
        .alert {
            padding: 16px 20px;
            border-radius: 10px;
            margin-bottom: 24px;
            display: flex;
            align-items: center;
            gap: 12px;
        }

        .alert i {
            font-size: 20px;
        }

        .alert-success {
            background: #d4edda;
            color: #155724;
            border-left: 4px solid #28a745;
        }

        .alert-error {
            background: #f8d7da;
            color: #721c24;
            border-left: 4px solid #dc3545;
        }

        .alert-warning {
            background: #fff3cd;
            color: #856404;
            border-left: 4px solid #ffc107;
        }

        /* Scrollbar - LAVENDER */
        .sidebar::-webkit-scrollbar {
            width: 6px;
        }

        .sidebar::-webkit-scrollbar-track {
            background: rgba(148, 148, 232, 0.1);
        }

        .sidebar::-webkit-scrollbar-thumb {
            background: rgba(148, 148, 232, 0.3);
            border-radius: 3px;
        }

        .sidebar::-webkit-scrollbar-thumb:hover {
            background: rgba(148, 148, 232, 0.5);
        }
    </style>

    <?php echo $__env->yieldPushContent('styles'); ?>
</head>
<body>
    <!-- Navbar -->
    <nav class="navbar">
        <div class="navbar-left">
            <!-- Toggle Button -->
            <button class="toggle-btn" onclick="toggleSidebar()">
                <i class="fas fa-bars"></i>
            </button>

            <div class="navbar-brand">
                <div class="brand-icon">
                    <i class="fas fa-umbrella-beach"></i>
                </div>
                <div class="brand-text">
                    <div class="brand-name">HIRBC</div>
                    <div class="brand-subtitle">BALI CANGGU</div>
                </div>
            </div>
        </div>
        
        <div class="navbar-actions">
            <a href="<?php echo e(route('dashboard')); ?>" class="btn-companies">
                <i class="fas fa-th"></i>
                <span>Back to Companies</span>
            </a>

            <div class="user-badge">
                <i class="fas fa-user-circle"></i>
                <span><?php echo e(Auth::user()->name); ?></span>
            </div>
            
            <form method="POST" action="<?php echo e(route('logout')); ?>" style="display: inline;">
                <?php echo csrf_field(); ?>
                <button type="submit" class="btn-logout">
                    <i class="fas fa-sign-out-alt"></i>
                    <span>Logout</span>
                </button>
            </form>
        </div>
    </nav>

    <!-- Sidebar -->
    <aside class="sidebar" id="sidebar">
        <ul class="sidebar-menu" style="padding-top: 20px;">
            <li>
                <a href="<?php echo e(route('hirbc.dashboard')); ?>" class="<?php echo e(request()->routeIs('hirbc.dashboard') ? 'active' : ''); ?>">
                    <i class="fas fa-home"></i>
                    <span>Dashboard</span>
                </a>
            </li>
            <li>
                <a href="<?php echo e(route('hirbc.manage-data')); ?>" class="<?php echo e(request()->routeIs('hirbc.manage-data*') ? 'active' : ''); ?>">
                    <i class="fas fa-database"></i>
                    <span>Manage Data</span>
                </a>
            </li>
        </ul>

        <div class="sidebar-divider"></div>
        <div class="sidebar-title">Room Categories</div>

        <ul class="sidebar-menu">
            <li>
                <a href="<?php echo e(route('hirbc.rooms.category', 'standard')); ?>" class="<?php echo e(request()->is('hirbc/rooms/standard*') ? 'active' : ''); ?>">
                    <i class="fas fa-bed"></i>
                    <span>Standard Rooms</span>
                </a>
            </li>
            <li>
                <a href="<?php echo e(route('hirbc.rooms.category', 'suite')); ?>" class="<?php echo e(request()->is('hirbc/rooms/suite*') ? 'active' : ''); ?>">
                    <i class="fas fa-crown"></i>
                    <span>Suite Rooms</span>
                </a>
            </li>
        </ul>

        <div class="sidebar-divider"></div>
        <div class="sidebar-title">Reports</div>

        <ul class="sidebar-menu">
            <li>
                <a href="<?php echo e(route('hirbc.reports.house-use')); ?>" class="<?php echo e(request()->routeIs('hirbc.reports.house-use*') ? 'active' : ''); ?>">
                    <i class="fas fa-house-user"></i>
                    <span>House Use</span>
                </a>
            </li>
            <li>
                <a href="<?php echo e(route('hirbc.reports.complimentary')); ?>" class="<?php echo e(request()->routeIs('hirbc.reports.complimentary*') ? 'active' : ''); ?>">
                    <i class="fas fa-gift"></i>
                    <span>Complimentary</span>
                </a>
            </li>
            <li>
                <a href="<?php echo e(route('hirbc.reports.ooo')); ?>" class="<?php echo e(request()->routeIs('hirbc.reports.ooo*') ? 'active' : ''); ?>">
                    <i class="fas fa-tools"></i>
                    <span>Out of Order</span>
                </a>
            </li>
            <li>
                <a href="<?php echo e(route('hirbc.reports.revenue')); ?>" class="<?php echo e(request()->routeIs('hirbc.reports.revenue*') ? 'active' : ''); ?>">
                    <i class="fas fa-dollar-sign"></i>
                    <span>Revenue</span>
                </a>
            </li>
        </ul>
    </aside>

    <!-- Main Content -->
    <main class="main-content" id="mainContent">
        <?php if(session('success')): ?>
            <div class="alert alert-success">
                <i class="fas fa-check-circle"></i>
                <div><?php echo e(session('success')); ?></div>
            </div>
        <?php endif; ?>

        <?php if(session('error')): ?>
            <div class="alert alert-error">
                <i class="fas fa-exclamation-circle"></i>
                <div><?php echo e(session('error')); ?></div>
            </div>
        <?php endif; ?>

        <?php if(session('warning')): ?>
            <div class="alert alert-warning">
                <i class="fas fa-exclamation-triangle"></i>
                <div><?php echo e(session('warning')); ?></div>
            </div>
        <?php endif; ?>

        <?php echo $__env->yieldContent('content'); ?>
    </main>

    <!-- Toggle Sidebar Script -->
    <script>
        function toggleSidebar() {
            const sidebar = document.getElementById('sidebar');
            const mainContent = document.getElementById('mainContent');
            
            sidebar.classList.toggle('collapsed');
            mainContent.classList.toggle('expanded');
            
            // Save state to localStorage
            if (sidebar.classList.contains('collapsed')) {
                localStorage.setItem('hirbcSidebarCollapsed', 'true');
            } else {
                localStorage.setItem('hirbcSidebarCollapsed', 'false');
            }
        }

        // Load saved state on page load
        document.addEventListener('DOMContentLoaded', function() {
            const isCollapsed = localStorage.getItem('hirbcSidebarCollapsed') === 'true';
            
            if (isCollapsed) {
                document.getElementById('sidebar').classList.add('collapsed');
                document.getElementById('mainContent').classList.add('expanded');
            }
        });
    </script>

    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>
</html><?php /**PATH C:\xampp\htdocs\room-monitoring-revenue\resources\views/layouts/hirbc.blade.php ENDPATH**/ ?>