<?php

namespace App\Imports;

use App\Models\ItemUserInput;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\WithHeadingRow;

class ItemUserInputImport implements ToCollection, WithHeadingRow
{
    protected int $itemRequestId;

    public function __construct(int $itemRequestId)
    {
        $this->itemRequestId = $itemRequestId;
    }

    public function collection(Collection $rows)
    {
        foreach ($rows as $row) {

            // Skip empty rows
            if (
                blank($row['storage_location'] ?? null) &&
                blank($row['code'] ?? null) &&
                blank($row['material_description'] ?? null)
            ) {
                continue;
            }

            ItemUserInput::create([
                'item_request_id'     => $this->itemRequestId,
                'storage_location'    => trim((string)($row['storage_location'] ?? '')),
                'code'                => trim((string)($row['code'] ?? '')),
                'material_description'=> trim((string)($row['material_description'] ?? '')),
                'actual'              => is_numeric($row['actual'] ?? null)
                                        ? (float)$row['actual']
                                        : null,
                'base_unit_of_measure'=> trim((string)($row['base_unit_of_measure'] ?? '')),
                'note'                => trim((string)($row['note'] ?? '')),
            ]);
        }
    }
}
