<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ExtendingRequest extends Model
{
    use HasFactory;

    protected $fillable = [
        'item_request_id',
        'action',
        'old_ending_date',
        'new_ending_date',
        'requested_by'
    ];

    public function itemRequest()
    {
        return $this->belongsTo(ItemRequest::class);
    }

    public function requestedBy()
    {
        return $this->belongsTo(User::class, 'requested_by');
    }
}
