<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOne;

class ItemRequest extends Model
{
    protected $fillable = [
        'company_id',
        'requester_id',      
        'flow_template_id',
        'current_step_no',
        'status',
        'posting_date',
        'remarks',
        'vendor_name',
        'location',
        'up_to_bc', 
    ];

    protected $casts = [
        'posting_date' => 'date',
    ];
    public function userRequests()
{
    return $this->hasMany(UserRequest::class, 'item_request_id');
}
    public function approvalInstances()
{
    return $this->hasMany(ApprovalInstance::class, 'item_request_id', 'id');
}
    public function requester(): BelongsTo { return $this->belongsTo(User::class, 'requester_id'); }
    public function lines(): HasMany { return $this->hasMany(ItemRequestLine::class, 'item_request_id'); }
    public function lines_vendor(): HasMany { return $this->hasMany(VendorRequestLine::class, 'item_request_id'); }
    public function flow(): BelongsTo { return $this->belongsTo(ApprovalFlowTemplate::class, 'flow_template_id'); }
    public function instance(): HasOne { return $this->hasOne(ApprovalInstance::class); }
    public function attachments(){return $this->hasMany(\App\Models\ItemRequestAttachment::class);}
    public function comments() {return $this->hasMany(ItemRequestComment::class, 'item_request_id');}
    public function company(): BelongsTo
    {
        return $this->belongsTo(\App\Models\Company::class, 'company_id');
    }
    public function updatedBy(): BelongsTo
    {
        return $this->belongsTo(User::class, 'updated_by');
    }

    protected static function booted()
    {
        static::updating(function ($model) {
            if(auth()->check()){
                $model->updated_by = auth()->user()->name;
            }
        });
    }

    public function itemUserInputs()
    {
        return $this->hasMany(ItemUserInput::class, 'item_request_id');
    }


}