<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class RequestsLog extends Model
{
    use HasFactory;

    protected $table = 'requests_log';

    protected $fillable = [
        'item_request_id',
        'request_type',
        'action',
        'requestby',
    ];

    /**
     * Relasi ke ItemRequest.
     * Satu log terkait ke satu item request (boleh duplikat item_request_id di tabel ini)
     */
    public function itemRequest()
    {
        return $this->belongsTo(ItemRequest::class, 'item_request_id');
    }
}
