<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class VendorRequestLine extends Model
{
    use HasFactory;

    protected $table = 'vendor_request_lines';

  protected $fillable = [
        'item_request_id',
        'company_id',
        'vendor_name',
        'address',
        'phone',
        'npwp',
        'bank_name',
        'account_holder',
        'account_number',
        'remarks', 
    ];

    /**
     * Relasi ke ItemRequest
     */
    public function itemRequest()
    {
        return $this->belongsTo(ItemRequest::class);
    }

    /**
     * Relasi ke Company
     */
    public function company()
    {
        return $this->belongsTo(Company::class);
    }
}
