<?php

// app/Notifications/ApprovalEventNotification.php
namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Notification;
use Illuminate\Notifications\Messages\MailMessage;

class ApprovalEventNotification extends Notification implements ShouldQueue
{
    use Queueable;

    public function __construct(
        public string $event,            
        public array $payload,
        public array $options = []
    ) {}

public function via($notifiable): array
{
    // Selalu simpan ke database
    $channels = ['database'];

    // Email hanya jika opsi channels mengaktifkannya
    if (($this->options['mail'] ?? true) === true) {
        $channels[] = 'mail';
    }

    return $channels;
}


    public function toMail($notifiable): MailMessage
    {
        $title = match ($this->event) {
            'submitted' => 'New request submitted',
            'requested' => 'Approval requested',
            'approved'  => 'Request approved',
            'rejected'  => 'Request rejected',
            'canceled'  => 'Request canceled',
            default     => 'Approval update',
        };

        $mail = (new MailMessage)
            ->subject("{$title} — #{$this->payload['number']}")
            ->greeting("Hello " . ($notifiable->name ?? ''))
            ->line($this->payload['title'] ?? 'Approval update')
            ->line("Request #: {$this->payload['number']} — Status: {$this->payload['status']}")
            ->action('Open Request', $this->payload['url'])
            ->line("Vendor: "    . ($this->payload['vendor']    ?? '—'))
            ->line("Requester: " . ($this->payload['requester'] ?? '—'))
            ->line("Posting: "   . ($this->payload['posting']   ?? '—'))
            ->line("Remarks: "   . ($this->payload['remarks']   ?? '—'))
            ->line('Thanks.');

        if (!empty($this->options['cc'])) {
            $mail->cc($this->options['cc']);
        }
        if (!empty($this->options['bcc'])) {
            $mail->bcc($this->options['bcc']);
        }

        return $mail;
    }

    public function toArray($notifiable): array
    {
        return [
            'event'      => $this->event,
            'request_id' => $this->payload['request_id'],
            'number'     => $this->payload['number'],
            'status'     => $this->payload['status'],
            'actor'      => $this->payload['actor'],   
            'title'      => $this->payload['title'],   
            'url'        => $this->payload['url'],
        ];
    }
}
