<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('opname_schedule', function (Blueprint $table) {
            $table->id();

            // Tanggal opname
            $table->date('date');

            // Status proses opname
            $table->enum('status', ['Pending', 'Start', 'End'])
                  ->default('Pending');

            // Periode opname (contoh: 2025-01, Q1-2025)
            $table->string('periode', 50);

            // User pembuat schedule
            $table->foreignId('created_by')
                  ->constrained('users')
                  ->cascadeOnDelete();

            // Timestamps
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('opname_schedule');
    }
};
