<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('item_user_inputs', function (Blueprint $table) {
            $table->string('storage_location', 50)->nullable()->after('id');
            $table->string('code', 50)->nullable()->after('storage_location');
            $table->string('material_description')->nullable()->after('code');
            $table->decimal('actual', 18, 4)->nullable()->after('material_description');
            $table->string('base_unit_of_measure', 20)->nullable()->after('actual');
            $table->text('note')->nullable()->after('base_unit_of_measure');
        });
    }

    public function down(): void
    {
        Schema::table('item_user_inputs', function (Blueprint $table) {
            $table->dropColumn([
                'storage_location',
                'code',
                'material_description',
                'actual',
                'base_unit_of_measure',
                'note',
            ]);
        });
    }
};
