<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('item_before_s2', function (Blueprint $table) {
            $table->id();

            $table->string('location', 20);
            $table->string('periode', 10)->nullable();

            $table->string('item_no', 50);
            $table->string('item_description')->nullable();

            $table->string('uom', 10)->nullable();

            $table->decimal('unit_cost', 15, 5)->default(0);
            $table->decimal('opening_balance', 15, 5)->default(0);

            // kumulatif dari BC
            $table->decimal('last_qty_increase', 15, 5)->default(0);
            $table->decimal('last_qty_decrease', 15, 5)->default(0);

            $table->integer('step')->default(2);
            $table->text('remarks')->nullable();

            $table->timestamps();

            // optional index (sangat disarankan)
            $table->index(['location', 'item_no']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('item_before_s2');
    }
};
