@extends('layouts.app')
@section('title', 'Edit Opname Request')

@push('styles')
<style>
    .card-rounded { border-radius: 1rem }
    .badge-soft {
        border: 1px solid rgba(0,0,0,.05);
        background: rgba(13,110,253,.06);
        color: #0d6efd;
    }
    .hint-box {
        background: #f8f9fa;
        border: 1px dashed #dee2e6;
        border-radius: .5rem;
        padding: .75rem;
        font-size: .875rem;
    }
</style>
@endpush

@section('content')
<div class="container my-4"
     x-data="editForm({
        company_id: '{{ old('company_id') ?? $req->company_id }}',
        flow_template_id: '{{ old('flow_template_id') ?? $req->flow_template_id }}',
        posting_date: '{{ old('posting_date') ?? $req->posting_date }}',
        remarks: @js(old('remarks') ?? $req->remarks),
        existingRows: @js($existingItems)
     })">

    {{-- ================= HEADER ================= --}}
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h1 class="h4 mb-0">Edit Opname Request #{{ $req->id }}</h1>
        <a href="{{ route('approvals.show', $req->id) }}" class="btn btn-outline-secondary">
            <i class="fa fa-arrow-left me-1"></i> Back
        </a>
    </div>

    <form method="POST"
          action="{{ route('approvals.update.excel', $req->id) }}"
          enctype="multipart/form-data"
          @submit="beforeSubmit"
          novalidate>
        @csrf

        {{-- ================= HEADER FORM ================= --}}
        <div class="card card-rounded shadow-sm mb-3">
            <div class="card-header bg-light fw-semibold d-flex justify-content-between">
                <span><i class="fa fa-circle-info me-2"></i>Header</span>

                <div class="d-flex gap-2">
                    <a href="{{ route('approvals.show', $req->id) }}"
                       class="btn btn-outline-secondary btn-sm">
                        Cancel
                    </a>
                    <button type="submit"
                            class="btn btn-success btn-sm"
                            :disabled="!canSubmit">
                        <i class="fa fa-save me-1"></i> Update
                    </button>
                </div>
            </div>

            <div class="card-body row g-3">
                <div class="col-md-3">
                    <label class="form-label">Company</label>
                    <select name="company_id"
                            class="form-select"
                            x-model="header.company_id"
                            required>
                        @foreach ($companies as $c)
                            <option value="{{ $c->id }}">
                                {{ $c->code }} — {{ $c->name }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <div class="col-md-4">
                    <label class="form-label">Flow Template</label>
                    <select name="flow_template_id"
                            class="form-select"
                            x-model="header.flow_template_id"
                            required>
                        @foreach ($flows as $f)
                            <option value="{{ $f->id }}">
                                {{ $f->name }} (v{{ $f->version }})
                            </option>
                        @endforeach
                    </select>
                </div>

                <div class="col-md-3">
                    <label class="form-label">Posting Date</label>
                    <input type="date"
                           name="posting_date"
                           class="form-control"
                           x-model="header.posting_date">
                </div>

                <div class="col-md-4">
                    <label class="form-label">Location</label>
                    <input type="text"
                           class="form-control"
                           value="{{ $req->location }}"
                           disabled>
                </div>

                <div class="col-12">
                    <label class="form-label">Remarks</label>
                    <textarea name="remarks"
                              rows="2"
                              class="form-control"
                              x-model="header.remarks"></textarea>
                </div>
            </div>
        </div>

        {{-- ================= EXCEL UPLOAD ================= --}}
        <div class="card card-rounded shadow-sm">
            <div class="card-header bg-light fw-semibold d-flex justify-content-between align-items-center">
                <div>
                    <i class="fa fa-paperclip me-2"></i>Excel Upload
                    <span class="badge badge-soft ms-2">Replace Data</span>
                </div>

                <a href="{{ asset('template_stockopname.xlsx') }}"
                   class="btn btn-outline-primary btn-sm"
                   target="_blank">
                    <i class="fa fa-download me-1"></i> Download Template
                </a>
            </div>

            <div class="card-body" x-data="excelUpload($root)">

                <div class="hint-box mb-3">
                    <strong>Edit Excel Data</strong>
                    <ul class="mb-1 ps-3">
                        <li>Upload Excel akan <b>mengganti seluruh data lama</b></li>
                        <li>Format harus sesuai template</li>
                        <li>Data lama akan dihapus saat submit</li>
                    </ul>
                </div>

                {{-- FILE INPUT --}}
                <input type="file"
                       class="form-control"
                       accept=".xlsx,.xls"
                       x-ref="fileInput"
                       @change="handleUpload">

                {{-- EXISTING DATA INFO --}}
                <template x-if="existingRows.length && !file">
                    <div class="alert alert-info mt-3">
                        <i class="fa fa-database me-1"></i>
                        Existing data loaded:
                        <strong x-text="existingRows.length"></strong> rows
                    </div>
                </template>

                {{-- PREVIEW --}}
                <template x-if="rows.length">
                    <div class="table-responsive mt-3">
                        <table class="table table-sm table-bordered">
                            <thead class="table-light">
                                <tr>
                                    <template x-for="h in headers" :key="h">
                                        <th x-text="h"></th>
                                    </template>
                                </tr>
                            </thead>
                            <tbody>
                                <template x-for="(r,i) in rows.slice(0,10)" :key="i">
                                    <tr>
                                        <template x-for="h in headers" :key="h">
                                            <td x-text="r[h]"></td>
                                        </template>
                                    </tr>
                                </template>
                            </tbody>
                        </table>
                        <div class="small text-muted">
                            Showing first 10 rows
                        </div>
                    </div>
                </template>

                {{-- PAYLOAD --}}
                <input type="hidden" name="excel_payload" :value="jsonPayload">
            </div>
        </div>
    </form>
</div>
@endsection

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/xlsx/dist/xlsx.full.min.js"></script>

<script>
document.addEventListener('alpine:init', () => {

    Alpine.data('editForm', (initial) => ({
        header: initial,
        canSubmit: initial.existingRows.length > 0,

        beforeSubmit(e) {
            if (!this.canSubmit) {
                e.preventDefault();
                alert('Please upload Excel before updating.');
            }
        }
    }));

    Alpine.data('excelUpload', (root) => ({
        file: null,
        rows: [],
        headers: [],
        error: null,
        status: null,
        existingRows: Alpine.$data(root).existingRows,

        get jsonPayload() {
            return JSON.stringify(this.rows.length ? this.rows : this.existingRows);
        },

        handleUpload(e) {
            this.reset();
            const f = e.target.files[0];
            if (!f) return;

            this.file = f;
            const reader = new FileReader();

            reader.onload = (evt) => {
                const wb = XLSX.read(evt.target.result, { type: 'array' });
                const sheet = wb.Sheets[wb.SheetNames[0]];
                const raw = XLSX.utils.sheet_to_json(sheet, { defval: '' });

                const normalized = raw.map(r => {
                    const o = {};
                    Object.keys(r).forEach(k => {
                        o[k.toLowerCase().trim().replace(/\s+/g,'_')] = r[k];
                    });
                    return o;
                });

                this.rows = normalized;
                this.headers = Object.keys(normalized[0] || {});
                Alpine.$data(root).canSubmit = true;
            };

            reader.readAsArrayBuffer(f);
        },

        reset() {
            this.rows = [];
            this.headers = [];
            this.file = null;
        }
    }));
});
</script>
@endpush
