<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Register | Stock Opname</title>
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;500;700;900&display=swap" rel="stylesheet">

<style>
body{margin:0;height:100vh;display:flex;justify-content:center;align-items:center;
background:linear-gradient(135deg,#ffffff,#eef3ff);font-family:'Inter',sans-serif;}
.card{width:400px;background:white;padding:32px;border-radius:22px;
box-shadow:0 15px 30px rgba(0,0,0,.08);}
input{width:100%;padding:12px;margin:10px 0;border-radius:10px;border:1px solid #d1d5db;}
button{width:100%;padding:12px;background:#2563eb;border:none;border-radius:12px;color:white;font-weight:700;}
button:hover{background:#1e4fd8;}
h2{text-align:center;font-weight:900;}
.error{color:#b91c1c;font-size:.9rem;}
</style>
</head>

<body>
<div class="card">
    <h2>Daftar Akun</h2>

    @if($errors->any())
        <div class="error">{{ $errors->first() }}</div>
    @endif

    <form method="POST" action="{{ route('register.store') }}">
        @csrf
        <input type="text" name="name" placeholder="Nama Lengkap" required value="{{ old('name') }}">
        <input type="email" name="email" placeholder="Email" required value="{{ old('email') }}">
        <input type="password" name="password" placeholder="Password (Min 8 Karakter)" required>
        <button type="submit">Buat Akun</button>
    </form>

    <p style="text-align:center;margin-top:10px;color:#6b7280;font-size:.9rem;">
        Sudah punya akun? <a href="{{ route('login') }}">Login</a>
    </p>
</div>
</body>
</html>
