
<?php $__env->startSection('title', 'My Form Lists'); ?>

<?php $__env->startPush('styles'); ?>
    <style>
        .empty {
            display: grid;
            place-items: center;
            padding: 6rem 1rem;
            color: #6c757d;
        }

        .card-rounded {
            border-radius: 1rem;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="container my-4">

        <?php
            $me = \App\Models\User::firstWhere('email', session('user.email') ?? (session('user')['email'] ?? null));
        ?>

        <div class="d-flex justify-content-between align-items-center mb-3">
            <div>
                <h4 class="mb-0">My Form Lists</h4>
                <small class="text-muted">All requests you created.</small>
            </div>

            <?php if($me && $me->canCreateItemRequests()): ?>
                <div class="d-flex gap-2">
                    <?php if($roleId == 6): ?>
                        <a href="<?php echo e(route('user-request.create')); ?>" class="btn btn-primary">
                            <i class="fa fa-plus me-1"></i> New Item Request
                        </a>
                        <a href="<?php echo e(route('allone-user-request.create')); ?>" class="btn btn-primary">
                            <i class="fa fa-plus me-1"></i> New All In One Item Request
                        </a>
                    <?php else: ?>
                        <a href="<?php echo e(route('approvals.new')); ?>" class="btn btn-primary">
                            <i class="fa fa-plus me-1"></i> New Item Request
                        </a>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
        </div>


        <?php if(($pendingForMe->total() ?? 0) > 0): ?>
            
            <div class="card card-rounded shadow-sm mb-4">
                <div class="card-header bg-light fw-semibold d-flex justify-content-between align-items-center">
                    <span><i class="fa fa-inbox me-2"></i>Requests awaiting my approval</span>
                    <span class="badge bg-primary"><?php echo e($pendingForMe->total()); ?></span>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-hover align-middle mb-0">
                            <thead class="table-light">
                                <tr>
                                    <th style="width:100px">#</th>
                                    <th>Requester</th>
                                    <th>Flow</th>
                                    <th>Location</th>
                                    <th>Created</th>
                                    <th>Step</th>
                                    <th style="width:290px">Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $pendingForMe; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td>
                                            <a class="text-decoration-none" href="<?php echo e(route('approvals.show', $row->id)); ?>">
                                                <span class="badge bg-secondary">#<?php echo e($row->id); ?></span>
                                            </a>
                                        </td>
                                        <td>
                                            <?php echo e($row->requester?->name ?? '—'); ?>

                                            <div class="small text-muted"><?php echo e($row->requester?->email); ?></div>
                                        </td>
                                        <td><?php echo e($row->flow?->name); ?> <?php if($row->flow?->version): ?>
                                                v<?php echo e($row->flow->version); ?>

                                            <?php endif; ?>
                                        </td>
                                        <td class="small"><?php echo e($row->location ?? '—'); ?></td> 
                                        <td class="text-muted small"><?php echo e($row->created_at?->format('Y-m-d H:i')); ?></td>
                                        <td>
                                            <span class="badge bg-info text-dark">
                                                <?php echo e($row->current_step_no); ?> /
                                                <?php echo e($stepsCount[$row->flow_template_id] ?? '—'); ?>

                                            </span>
                                        </td>
                                        <td>
                                            <form class="d-flex gap-2 align-items-center approval-row" method="POST">
                                                <?php echo csrf_field(); ?>

                                                <input type="text" name="comment" class="form-control form-control-sm"
                                                    placeholder="Comment (optional)">

                                                <button formaction="<?php echo e(route('approvals.web.approve', $row->id)); ?>"
                                                    class="btn btn-success btn-sm px-3">
                                                    <i class="fa fa-thumbs-up"></i>
                                                </button>

                                                <button formaction="<?php echo e(route('approvals.web.reject', $row->id)); ?>"
                                                    class="btn btn-danger btn-sm px-3">
                                                    <i class="fa fa-thumbs-down"></i>
                                                </button>
                                            </form>

                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                    <div class="p-3"><?php echo e($pendingForMe->links('pagination::bootstrap-5')); ?>

                    </div>
                </div>
            </div>
        <?php else: ?>
            
            <div class="empty">
                <div class="text-center">
                    <div class="display-6 mb-2"><i class="fa fa-box-open"></i></div>
                    <div class="fw-semibold">No forms yet</div>
                    <div class="small">Create a new request to see it here.</div>
                </div>
            </div>
        <?php endif; ?>

        <?php if(($itemsByPic->total() ?? 0) > 0): ?>
            <div class="card card-rounded shadow-sm mb-4">
                <div class="card-header bg-light fw-semibold">
                    <i class="fa fa-file-alt me-2"></i>User Requests
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-sm align-middle mb-0">
                            <thead class="table-light">
                                <tr>
                                    <th style="width:90px">#</th>
                                    <th>Status</th>
                                    <th>Lines</th>
                                    <th>Item Name</th>
                                    <th>Vendor</th>
                                    <th>User</th> 
                                    <th>Posting Date</th>
                                    <th>Updated</th>
                                    <th>Step</th>
                                    <th style="width:120px">Open</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $itemsByPic; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $it): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><span class="badge bg-secondary">#<?php echo e($it->id); ?></span></td>
                                        <td>
                                            <?php
                                                $cls = match ($it->status) {
                                                    'Draft' => 'bg-secondary',
                                                    'InReview' => 'bg-warning text-dark',
                                                    'Approved' => 'bg-success',
                                                    'Rejected' => 'bg-danger',
                                                    'Cancelled  ' => 'bg-dark',
                                                    default => 'bg-secondary',
                                                };
                                            ?>
                                            <span class="badge <?php echo e($cls); ?>"><?php echo e($it->status); ?></span>
                                        </td>
                                        <?php if($it->flow_template_id == 6): ?>
                                            <td><span class="badge bg-primary"><?php echo e($it->lines_vendor_count); ?></span></td>
                                        <?php else: ?>
                                            <td><span class="badge bg-primary"><?php echo e($it->lines_count); ?></span></td>
                                        <?php endif; ?>
                                        <td class="small"><?php echo e($it->lines->first()?->article_name ?? '—'); ?></td>
                                        <td class="small"><?php echo e($it->vendor_name ?? '—'); ?></td>

                                        
                                        <td class="small">
                                            <?php if($it->userRequests->isNotEmpty()): ?>
                                                <?php $__currentLoopData = $it->userRequests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ur): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <span class="badge bg-info text-dark mb-1">
                                                        <?php echo e($ur->user->name ?? '—'); ?>

                                                    </span>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php else: ?>
                                                —
                                            <?php endif; ?>
                                        </td>

                                        <td class="small text-muted"><?php echo e($it->posting_date?->format('Y-m-d') ?? '—'); ?></td>
                                        <td class="small text-muted"><?php echo e($it->updated_at?->format('Y-m-d H:i')); ?></td>
                                        <td>
                                            <span class="badge bg-info text-dark">
                                                <?php echo e($it->current_step_no); ?> /
                                                <?php echo e($stepsCount[$it->flow_template_id] ?? '—'); ?>

                                            </span>
                                        </td>
                                        <?php $me = \App\Models\User::firstWhere('email', session('user.email') ?? session('user')['email'] ?? null); ?>
                                        <td class="text-end">
                                            <div class="d-flex gap-2 justify-content-end">
                                                <a href="<?php echo e(route('approvals.show', $it->id)); ?>"
                                                    class="btn btn-outline-primary btn-sm">
                                                    <i class="fa fa-eye"></i> View
                                                </a>

                                                <?php if($it->status === 'Draft' && ($it->requester_id === optional($me)->id || optional($me)->isAdmin())): ?>
                                                    <form method="POST" action="<?php echo e(route('approvals.destroy', $it->id)); ?>"
                                                        onsubmit="return confirm('Delete this draft permanently?');">
                                                        <?php echo csrf_field(); ?>
                                                        <?php echo method_field('DELETE'); ?>
                                                        <button class="btn btn-outline-danger btn-sm">
                                                            <i class="fa fa-trash"></i>
                                                            Delete
                                                        </button>
                                                    </form>
                                                <?php endif; ?>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                    <div class="p-3"><?php echo e($itemsByPic->links('pagination::bootstrap-5')); ?>

                    </div>
                </div>
            </div>
        <?php endif; ?>


        
        

        <?php if(($items->count() ?? 0) > 0 && $roleId == 6): ?>
            <div class="card card-rounded shadow-sm mb-4">
                <div class="card-header bg-light fw-semibold">
                    <i class="fa fa-file-alt me-2"></i>My Requests
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-sm align-middle mb-0 ">
                            <thead class="table-light">
                                <tr>
                                    <th style="width:90px">#</th>
                                    <th>Status</th>
                                    <th>Lines</th>
                                    <th>Location</th>
                                    <th>Item Name</th>
                                    <th>PIC</th>
                                    <th>Posting Date</th>
                                    <th>Updated</th>
                                    <th>Step</th>
                                    <th style="width:120px">Open</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $it): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><span class="badge bg-secondary">#<?php echo e($it->id); ?></span></td>

                                        <td>
                                            <?php
                                                $cls = match ($it->status) {
                                                    'Draft' => 'bg-secondary',
                                                    'InReview' => 'bg-warning text-dark',
                                                    'Approved' => 'bg-success',
                                                    'Rejected' => 'bg-danger',
                                                    'Cancelled' => 'bg-dark',
                                                    default => 'bg-secondary',
                                                };
                                            ?>
                                            <span class="badge <?php echo e($cls); ?>"><?php echo e($it->status); ?></span>
                                        </td>

                                        <?php if($it->flow_template_id == 6): ?>
                                            <td><span class="badge bg-primary"><?php echo e($it->lines_vendor_count); ?></span></td>
                                        <?php else: ?>
                                            <td><span class="badge bg-primary"><?php echo e($it->lines_count); ?></span></td>
                                        <?php endif; ?>

                                        <td class="small"><?php echo e($it->vendor_name ?? '—'); ?></td>
                                        <td class="small"><?php echo e($it->userRequests->first()->item_name ?? '—'); ?></td>
                                        <td class="small">
                                            <?php echo e(optional($it->userRequests->first()?->picUser)->name ?? '—'); ?>

                                        </td>
                                        <td class="small text-muted"><?php echo e($it->posting_date?->format('Y-m-d') ?? '—'); ?></td>
                                        <td class="small text-muted"><?php echo e($it->updated_at?->format('Y-m-d H:i')); ?></td>

                                        <td>
                                            <span class="badge bg-info text-dark">
                                                <?php echo e($it->current_step_no); ?> /
                                                <?php echo e($stepsCount[$it->flow_template_id] ?? '—'); ?>

                                            </span>
                                        </td>

                                        <td class="text-end">
                                            <a href="<?php echo e(route('approvals.show', $it->id)); ?>"
                                                class="btn btn-outline-primary btn-sm">
                                                <i class="fa fa-eye"></i> View
                                            </a>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>

                    <div class="p-3">
                        
                    </div>

                </div>
            </div>
        <?php else: ?>
            <div class="card card-rounded shadow-sm mb-4">
                <div class="card-header bg-light fw-semibold">
                    <i class="fa fa-file-alt me-2"></i>My Requests
                </div>

                <div class="card-body p-0">
                    <div class="table-responsive">

                        <table class="table table-sm align-middle mb-0" id="myRequestsTable">
                            <thead class="table-light">
                                <tr>
                                    <th style="width:90px" class="sortable" data-field="id">#</th>
                                    <th>
                                        <select id="statusFilter" class="form-select form-select-sm">
                                            <option value="">Status</option>
                                            <option value="Draft">Draft</option>
                                            <option value="InReview">InReview</option>
                                            <option value="Rejected">Rejected</option>
                                            <option value="Cancelled">Cancelled</option>
                                            <option value="Approved">Approved</option>
                                        </select>
                                    </th>

                                    <th class="sortable" data-field="lines">Lines</th>
                                    <th class="sortable" data-field="vendor">Location</th>
                                    <th class="sortable" data-field="item">Periode</th>
                                    <th class="sortable" data-field="pic">Up BC</th>
                                    <th class="sortable" data-field="posting">Posting Date</th>
                                    <th class="sortable" data-field="updated">Updated</th>
                                    <th class="sortable" data-field="step">Step</th>
                                    <th style="width:120px">Open</th>
                                </tr>
                            </thead>

                            <tbody>
                                <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $it): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><span class="badge bg-secondary">#<?php echo e($it->id); ?></span></td>

                                        <td>
                                            <?php
                                                $cls = match ($it->status) {
                                                    'Draft' => 'bg-secondary',
                                                    'InReview' => 'bg-warning text-dark',
                                                    'Approved' => 'bg-success',
                                                    'Rejected' => 'bg-danger',
                                                    'Cancelled' => 'bg-dark',
                                                    default => 'bg-secondary',
                                                };
                                            ?>
                                            <span class="badge <?php echo e($cls); ?>"><?php echo e($it->status); ?></span>
                                        </td>

                                        <td><span class="badge bg-primary">
                                                <?php echo e($it->flow_template_id == 6 ? $it->lines_vendor_count : $it->lines_count); ?>

                                            </span></td>

                                        <td class="small"><?php echo e($it->location ?? '—'); ?></td>
                                        <td class="small"><?php echo e(\Carbon\Carbon::parse($it->requested_at)->format('Y-m')); ?>

                                        </td>

                                        <td class="small"><?php echo e(Str::upper($it->up_to_bc ?? '—')); ?></td>
                                        <td class="small text-muted"><?php echo e($it->posting_date?->format('Y-m-d') ?? '—'); ?></td>
                                        <td class="small text-muted"><?php echo e($it->updated_at?->format('Y-m-d H:i')); ?></td>

                                        <td>
                                            <span class="badge bg-info text-dark">
                                                <?php echo e($it->current_step_no); ?> /
                                                <?php echo e($stepsCount[$it->flow_template_id] ?? '—'); ?>

                                            </span>
                                        </td>

                                        <td class="text-end">
                                            <a href="<?php echo e(route('approvals.show', $it->id)); ?>"
                                                class="btn btn-outline-primary btn-sm">
                                                <i class="fa fa-eye"></i> View
                                            </a>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>

                    </div>

                    <div class="p-3">
                        <div id="clientPagination" class="d-flex justify-content-end"></div>
                    </div>
                </div>
            </div>
        <?php endif; ?>



    </div>
    <script>
        document.addEventListener('DOMContentLoaded', () => {

            const tableBody = document.querySelector('#myRequestsTable tbody');
            const paginationBox = document.querySelector('#clientPagination');
            const statusFilter = document.getElementById('statusFilter');

            // Ambil data asli langsung dari DOM
            let allRows = Array.from(tableBody.querySelectorAll('tr'));

            let viewRows = [];
            let currentPage = 1;
            const perPage = 20;

            let sortField = null;
            let sortDir = 'asc';

            // DEFAULT SORT → ID DESC
            viewRows = [...allRows].sort((a, b) =>
                extract(a, 'id') < extract(b, 'id') ? 1 : -1
            );

            renderPage();
            renderPagination();
            updateSortIcons();

            // EXTRACT VALUE
            function extract(row, field) {
                switch (field) {
                    case 'id':
                        return Number(row.querySelector('td:nth-child(1) span')
                            .innerText.replace('#', ''));

                    case 'lines':
                        return Number(row.querySelector('td:nth-child(3) span').innerText);

                    case 'vendor':
                        return row.querySelector('td:nth-child(4)').innerText.trim();

                    case 'item':
                        return row.querySelector('td:nth-child(5)').innerText.trim();

                    case 'pic':
                        return row.querySelector('td:nth-child(6)').innerText.trim();

                    case 'posting':
                        return row.querySelector('td:nth-child(7)').innerText.trim();

                    case 'updated':
                        return row.querySelector('td:nth-child(8)').innerText.trim();

                    case 'step':
                        return Number(row.querySelector('td:nth-child(9) span')
                            .innerText.split('/')[0].trim());

                    case 'status':
                        return row.querySelector('td:nth-child(2) span').innerText.trim();
                }
                return '';
            }

            // SORTING
            function sortData(field) {
                if (sortField === field) {
                    sortDir = sortDir === 'asc' ? 'desc' : 'asc';
                } else {
                    sortField = field;
                    sortDir = 'asc';
                }

                viewRows.sort((a, b) => {
                    let A = extract(a, field);
                    let B = extract(b, field);

                    if (A < B) return sortDir === 'asc' ? -1 : 1;
                    if (A > B) return sortDir === 'asc' ? 1 : -1;
                    return 0;
                });

                currentPage = 1;
                renderPage();
                renderPagination();
                updateSortIcons();
            }

            // FILTER STATUS
            statusFilter.addEventListener('change', () => {
                const selected = statusFilter.value;

                if (selected === "") {
                    viewRows = [...allRows].sort((a, b) =>
                        extract(a, 'id') < extract(b, 'id') ? 1 : -1
                    );
                } else {
                    const match = [];
                    const others = [];

                    allRows.forEach(r => {
                        extract(r, 'status') === selected ? match.push(r) : others.push(r);
                    });

                    match.sort((a, b) => extract(b, 'id') - extract(a, 'id'));
                    others.sort((a, b) => extract(b, 'id') - extract(a, 'id'));

                    viewRows = [...match, ...others];
                }

                currentPage = 1;
                renderPage();
                renderPagination();
                updateSortIcons();
            });

            // RENDER PAGE
            function renderPage() {
                tableBody.innerHTML = "";

                const start = (currentPage - 1) * perPage;
                const end = start + perPage;

                viewRows.slice(start, end).forEach(r => tableBody.appendChild(r));
            }

            // PAGINATION
            function renderPagination() {
                const total = viewRows.length;
                const pages = Math.ceil(total / perPage);

                if (pages <= 1) {
                    paginationBox.innerHTML = "";
                    return;
                }

                let html = `<ul class="pagination">`;

                for (let p = 1; p <= pages; p++) {
                    html += `
                <li class="page-item ${p === currentPage ? 'active' : ''}">
                    <a class="page-link" href="#" data-page="${p}">${p}</a>
                </li>`;
                }

                html += `</ul>`;
                paginationBox.innerHTML = html;

                paginationBox.querySelectorAll('a').forEach(a => {
                    a.addEventListener('click', e => {
                        e.preventDefault();
                        currentPage = Number(a.dataset.page);
                        renderPage();
                        renderPagination();
                    });
                });
            }

            // SORT ICON UPDATE
            function updateSortIcons() {
                document.querySelectorAll('.sortable .sort-icon')
                    .forEach(icon => icon.classList.remove('asc', 'desc'));

                if (!sortField) return;

                const active = document.querySelector(
                    `.sortable[data-field="${sortField}"] .sort-icon`
                );

                if (active) active.classList.add(sortDir === 'asc' ? 'asc' : 'desc');
            }

            // ADD ICONS TO HEADER
            document.querySelectorAll('.sortable').forEach(th => {
                const icon = document.createElement('span');
                icon.classList.add('sort-icon');
                th.appendChild(icon);

                th.addEventListener('click', () => sortData(th.dataset.field));
            });

        });
    </script>




    <style>
        /* Container untuk kolom sortable */
        .sortable {
            position: relative;
            padding-right: 18px !important;
            cursor: pointer;
            user-select: none;
        }

        /* Base: chevron kecil */
        .sort-icon {
            width: 8px;
            height: 8px;
            position: absolute;
            right: 4px;
            top: 50%;
            translate: 0 -50%;
            opacity: 0.25;
            transition: transform .15s ease, opacity .15s ease;
        }

        /* Bentuk panah dasar (chevron) */
        .sort-icon::before {
            content: "";
            position: absolute;
            width: 6px;
            height: 6px;
            border-right: 2px solid #555;
            border-bottom: 2px solid #555;
            transform: rotate(45deg);
            top: 1px;
            left: 0;
        }

        /* ASC (↑) */
        .sort-icon.asc {
            opacity: 1;
        }

        .sort-icon.asc::before {
            transform: rotate(225deg);
            /* arah ke atas */
        }

        /* DESC (↓) */
        .sort-icon.desc {
            opacity: 1;
        }

        .sort-icon.desc::before {
            transform: rotate(45deg);
            /* arah ke bawah */
        }

        /* Hover effect */
        .sortable:hover .sort-icon {
            opacity: 0.5;
        }
    </style>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Lenovo\OneDrive\Documents\Kerjaan\stockopname\resources\views/approvals/my_forms.blade.php ENDPATH**/ ?>