

<?php $__env->startPush('styles'); ?>
<style>
/* ================= LAYOUT ================= */
.page-wrap {
    padding: 12px 16px;
}

/* ================= CARD ================= */
.card-soft {
    border-radius: 14px;
    border: 1px solid #e5e7eb;
    box-shadow: 0 8px 20px rgba(0,0,0,.04);
    background: #fff;
}

/* ================= HEADER BAR ================= */
.toolbar {
    display: flex;
    justify-content: space-between;
    align-items: center;
    gap: 12px;
}

.toolbar-right {
    display: flex;
    gap: 8px;
    align-items: center;
}

.search-box {
    width: 260px;
}

/* ================= TABLE ================= */
.table-container {
    max-height: 72vh;
    overflow-y: auto;
}

table {
    width: 100%;
    table-layout: fixed;
    font-size: .82rem;
}

thead th {
    position: sticky;
    top: 0;
    background: #f8fafc;
    z-index: 3;
    font-size: .72rem;
    font-weight: 700;
    text-transform: uppercase;
    color: #475569;
    cursor: pointer;
    user-select: none;
    white-space: nowrap;
}

thead th.no-sort {
    cursor: default;
}

tbody tr:hover {
    background: #f9fafb;
}

td {
    padding: 4px;
    vertical-align: middle;
}

/* ================= INPUT ================= */
.input-soft {
    width: 100%;
    border-radius: 8px;
    border: 1px solid #e5e7eb;
    padding: 4px 6px;
    font-size: .78rem;
}

.input-soft:focus {
    outline: none;
    border-color: #6366f1;
    box-shadow: 0 0 0 2px rgba(99,102,241,.15);
}

input[type=number]::-webkit-inner-spin-button,
input[type=number]::-webkit-outer-spin-button {
    -webkit-appearance: none;
}
input[type=number] {
    -moz-appearance: textfield;
}

.num {
    text-align: right;
    font-variant-numeric: tabular-nums;
}

/* ================= COLUMN WIDTH ================= */
.col-item   { width: 90px; }
.col-desc   { width: 220px; }
.col-uom    { width: 60px; }
.col-num    { width: 90px; }
.col-remark { width: 180px; }

/* ================= SORT ICON ================= */
.sort-icon {
    display: inline-block;
    margin-left: 4px;
    vertical-align: middle;
}

.sort-icon svg {
    width: 10px;
    height: 10px;
    opacity: .35;
}

th.active .sort-icon svg {
    opacity: 1;
    color: #4f46e5;
}
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="page-wrap">

    
    <div class="toolbar mb-2">
        <div>
            <h6 class="fw-bold mb-0">
                📍 <?php echo e($location->code); ?> — <?php echo e($location->name); ?>

            </h6>
            <div class="text-muted small">
                Process Item Adjustment • Request #<?php echo e($request->id); ?>

            </div>
        </div>

        <div class="toolbar-right">
            <input id="searchInput"
                   type="text"
                   class="form-control form-control-sm search-box"
                   placeholder="Search item / description">

            <button id="btnSave" class="btn btn-success btn-sm px-3">
                Save
            </button>

            <a href="<?php echo e(route('approvals.show', $request->id)); ?>"
               class="btn btn-outline-secondary btn-sm px-3">
                Cancel
            </a>
        </div>
    </div>

    
    <div class="card-soft p-2">
        <div class="table-container">
            <table class="table table-sm mb-0" id="itemTable">
                <thead>
                <tr>
                    <?php
                        $headers = [
                            'item_no' => 'Item',
                            'item_description' => 'Description',
                            'uom' => 'UOM',
                            'unit_cost' => 'Cost',
                            'opening_balance' => 'Opening',
                            'increase' => 'Inc',
                            'decrease' => 'Dec',
                            'ending_balance' => 'Ending',
                            'blind_count' => 'Blind'
                        ];
                    ?>

                    <?php $__currentLoopData = $headers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <th data-key="<?php echo e($key); ?>" class="<?php echo e(in_array($key,['item_no']) ? 'col-item' : ''); ?> <?php echo e(in_array($key,['item_description']) ? 'col-desc' : ''); ?> <?php echo e(is_numeric($key) ? 'num' : ''); ?>">
                            <?php echo e($label); ?>

                            <span class="sort-icon">
                                <svg viewBox="0 0 20 20" fill="currentColor">
                                    <path d="M10 6l4 6H6l4-6z"/>
                                </svg>
                            </span>
                        </th>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    <th class="num no-sort">Variance</th>
                    <th class="num no-sort">Total</th>
                    <th class="col-remark no-sort">Remarks</th>
                </tr>
                </thead>

                <tbody>
                <?php $__currentLoopData = $rows; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr data-row
                    data-item="<?php echo e(strtolower($r['item_no'])); ?>"
                    data-desc="<?php echo e(strtolower($r['item_description'])); ?>">

                    <td data-col="item_no"><strong><?php echo e($r['item_no']); ?></strong></td>
                    <td data-col="item_description"><input class="input-soft desc" value="<?php echo e($r['item_description']); ?>"></td>
                    <td data-col="uom"><input class="input-soft uom" value="<?php echo e($r['uom']); ?>"></td>

                    <td data-col="unit_cost"><input type="number" class="input-soft num unit" value="<?php echo e($r['unit_cost']); ?>"></td>
                    <td data-col="opening_balance"><input type="number" class="input-soft num opening" value="<?php echo e($r['opening_balance']); ?>"></td>
                    <td data-col="increase"><input type="number" class="input-soft num inc" value="<?php echo e($r['increase']); ?>"></td>
                    <td data-col="decrease"><input type="number" class="input-soft num dec" value="<?php echo e($r['decrease']); ?>"></td>
                    <td data-col="ending_balance"><input type="number" class="input-soft num ending" value="<?php echo e($r['ending_balance']); ?>"></td>
                    <td data-col="blind_count"><input type="number" class="input-soft num blind" value="<?php echo e($r['blind_count']); ?>"></td>

                    <td><input class="input-soft num variance" value="<?php echo e($r['variance']); ?>" readonly></td>
                    <td><input class="input-soft num total" value="<?php echo e($r['total_cost']); ?>" readonly></td>
                    <td><input class="input-soft remarks" value="<?php echo e($r['remarks']); ?>"></td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
/* ================= SEARCH ================= */
document.getElementById('searchInput').addEventListener('input', function () {
    const q = this.value.toLowerCase();
    document.querySelectorAll('[data-row]').forEach(row => {
        const hit = row.dataset.item.includes(q) || row.dataset.desc.includes(q);
        row.style.display = hit ? '' : 'none';
    });
});

/* ================= SORT ================= */
let sortDir = {};

document.querySelectorAll('th[data-key]').forEach(th => {
    const key = th.dataset.key;
    sortDir[key] = 1;

    th.addEventListener('click', () => {
        sortDir[key] *= -1;

        document.querySelectorAll('th').forEach(h => h.classList.remove('active'));
        th.classList.add('active');

        const rows = [...document.querySelectorAll('#itemTable tbody tr')];
        rows.sort((a, b) => {
            const av = a.querySelector(`[data-col="${key}"] input`)?.value || a.querySelector(`[data-col="${key}"]`)?.innerText;
            const bv = b.querySelector(`[data-col="${key}"] input`)?.value || b.querySelector(`[data-col="${key}"]`)?.innerText;

            return isNaN(av) ? av.localeCompare(bv) * sortDir[key] : (av - bv) * sortDir[key];
        });

        const tbody = document.querySelector('#itemTable tbody');
        rows.forEach(r => tbody.appendChild(r));
    });
});

/* ================= RECALC ================= */
document.querySelectorAll('[data-row]').forEach(row => {
    const blind = row.querySelector('.blind');
    const ending = row.querySelector('.ending');
    const unit = row.querySelector('.unit');
    const variance = row.querySelector('.variance');
    const total = row.querySelector('.total');

    function recalc() {
        const b = parseFloat(blind.value) || 0;
        const e = parseFloat(ending.value) || 0;
        const u = parseFloat(unit.value) || 0;
        const v = b ? (b - e) : 0;
        variance.value = v.toFixed(4);
        total.value = (v * u).toFixed(2);
    }

    blind.addEventListener('input', recalc);
    ending.addEventListener('input', recalc);
    unit.addEventListener('input', recalc);
});

/* ================= AJAX SAVE ================= */
document.getElementById('btnSave').addEventListener('click', async () => {
    const items = [];

    document.querySelectorAll('[data-row]').forEach(row => {
        items.push({
            item_no: row.querySelector('[data-col="item_no"] strong').innerText,
            location: "<?php echo e($location->code); ?>",
            item_description: row.querySelector('.desc').value,
            uom: row.querySelector('.uom').value,
            unit_cost: +row.querySelector('.unit').value || 0,
            opening_balance: +row.querySelector('.opening').value || 0,
            increase: +row.querySelector('.inc').value || 0,
            decrease: +row.querySelector('.dec').value || 0,
            ending_balance: +row.querySelector('.ending').value || 0,
            blind_count: +row.querySelector('.blind').value || 0,
            variance: +row.querySelector('.variance').value || 0,
            total_cost: +row.querySelector('.total').value || 0,
            remarks: row.querySelector('.remarks').value
        });
    });

    await fetch("<?php echo e(route('item-after.ajax.store', $request->id)); ?>", {
        method: "POST",
        headers: {
            "Content-Type": "application/json",
            "X-CSRF-TOKEN": document.querySelector('meta[name=csrf-token]').content
        },
        body: JSON.stringify({ items })
    });

    window.location.href = "<?php echo e(route('approvals.show', $request->id)); ?>";
});
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Lenovo\OneDrive\Documents\Kerjaan\stockopname\resources\views/item_after/process.blade.php ENDPATH**/ ?>