
<?php $__env->startSection('title','Admin — Approvals Management'); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .pill { border-radius: 999px; }
    .card-rounded { border-radius: 1rem; }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="container py-4">
    <?php if(session('success')): ?>
        <div class="alert alert-success"><i class="fa fa-check-circle me-1"></i><?php echo e(session('success')); ?></div>
    <?php endif; ?>
    <?php if($errors->any()): ?>
        <div class="alert alert-danger"><i class="fa fa-triangle-exclamation me-1"></i><?php echo e($errors->first()); ?></div>
    <?php endif; ?>

    <ul class="nav nav-pills mb-3">
        <li class="nav-item"><a class="nav-link <?php echo e($tab==='flows'?'active':''); ?>" href="<?php echo e(route('admin.index',['tab'=>'flows'])); ?>#flows"><i class="fa fa-diagram-project me-1"></i>Flows</a></li>
        <li class="nav-item"><a class="nav-link <?php echo e($tab==='users'?'active':''); ?>" href="<?php echo e(route('admin.index',['tab'=>'users'])); ?>#users"><i class="fa fa-users me-1"></i>Users</a></li>
        <li class="nav-item"><a class="nav-link <?php echo e($tab==='instances'?'active':''); ?>" href="<?php echo e(route('admin.index',['tab'=>'instances'])); ?>#instances"><i class="fa fa-list-check me-1"></i>Instances</a></li>
        <li class="nav-item"><a class="nav-link <?php echo e($tab==='requests'?'active':''); ?>" href="<?php echo e(route('admin.index',['tab'=>'requests'])); ?>#requests"><i class="fa fa-file-pen me-1"></i>Requests</a></li>
        <li class="nav-item">
          <a class="nav-link <?php echo e($tab==='roles'?'active':''); ?>" 
             href="<?php echo e(route('admin.index',['tab'=>'roles'])); ?>#roles">
             <i class="fa fa-id-badge me-1"></i>Roles
          </a>
        </li>
        <li class="nav-item"><a class="nav-link <?php echo e($tab==='requests'?'active':''); ?>" href="<?php echo e(route('activity.logs',['tab'=>'requests'])); ?>#requests"><i class="fa-solid fa-scroll"></i>Logs History</a></li>

    </ul>

    <?php if($tab === 'flows'): ?>
    <a id="flows"></a>
    <div class="card card-rounded mb-4">
        <div class="card-header bg-primary text-white"><i class="fa fa-plus me-1"></i>Create Flow Template</div>
        <div class="card-body">
            <form class="row g-3" method="POST" action="<?php echo e(route('admin.flows.store')); ?>">
                <?php echo csrf_field(); ?>
                <div class="col-md-4">
                    <label class="form-label">Name</label>
                    <input name="name" class="form-control" placeholder="New Item SOP v2" required>
                </div>
                <div class="col-md-3">
                    <label class="form-label">Object Type</label>
                    <input name="object_type" class="form-control" value="NewItem" required>
                </div>
                <div class="col-md-2">
                    <label class="form-label">Version</label>
                    <input type="number" min="1" name="version" class="form-control" value="1" required>
                </div>
                <div class="col-md-3 d-flex align-items-end">
                    <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" name="is_active" id="is_active" value="1" checked>
                        <label class="form-check-label" for="is_active">Active</label>
                    </div>
                </div>
                <div class="col-12">
                    <button class="btn btn-primary"><i class="fa fa-save me-1"></i>Save Flow</button>
                </div>
            </form>
        </div>
    </div>

    <?php $__currentLoopData = $flows; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $flow): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <div class="card card-rounded mb-3">
        <div class="card-header d-flex justify-content-between align-items-center">
            <div>
                <span class="badge <?php echo e($flow->is_active ? 'bg-success':'bg-secondary'); ?>"><?php echo e($flow->is_active ? 'Active' : 'Inactive'); ?></span>
                <strong class="ms-2"><?php echo e($flow->name); ?></strong>
                <span class="text-muted ms-1">(<?php echo e($flow->object_type); ?>, v<?php echo e($flow->version); ?>)</span>
            </div>
            <div class="d-flex gap-2">
                <form method="POST" action="<?php echo e(route('admin.flows.toggle',$flow)); ?>"><?php echo csrf_field(); ?>
                    <button class="btn btn-outline-secondary btn-sm"><i class="fa fa-toggle-on"></i></button>
                </form>
                <form method="POST" action="<?php echo e(route('admin.flows.destroy',$flow)); ?>" onsubmit="return confirm('Delete this flow?');">
                    <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                    <button class="btn btn-outline-danger btn-sm"><i class="fa fa-trash"></i></button>
                </form>
            </div>
        </div>
        <div class="card-body">
            <div class="table-responsive mb-3">
                <table class="table table-sm align-middle">
                    <thead class="table-light">
                        <tr>
                            <th style="width:80px">Step</th>
                            <th>Approver (User)</th>
                            <th>Approver (Role)</th>
                            <th style="width:80px">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $flow->steps; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $step): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><span class="badge bg-info">#<?php echo e($step->step_no); ?></span></td>
                            <td>
                                <?php $multi = $step->approvers ?? collect(); ?>
                            
                                <?php if($multi->isNotEmpty()): ?>
                                  <?php $__currentLoopData = $multi; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ap): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($ap->approver_user_id): ?>
                                      <div class="mb-1">
                                        <strong><?php echo e($ap->user?->name ?? "User #{$ap->approver_user_id}"); ?></strong>
                                        <div class="small text-muted"><?php echo e($ap->user?->email ?? '—'); ?></div>
                                      </div>
                                    <?php endif; ?>
                                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php elseif(!empty($step->approver_user_id)): ?>
                                  <strong><?php echo e($step->approverUser?->name ?? "User #{$step->approver_user_id}"); ?></strong>
                                  <div class="small text-muted"><?php echo e($step->approverUser?->email ?? ''); ?></div>
                                <?php else: ?>
                                  <span class="text-muted">—</span>
                                <?php endif; ?>
                              </td>
                            
                              <td>
                                <?php if($multi->isNotEmpty()): ?>
                                  <?php $__currentLoopData = $multi; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ap): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($ap->approver_role_id): ?>
                                      <div class="small mb-1"><?php echo e($ap->role?->code ?? "Role #{$ap->approver_role_id}"); ?></div>
                                    <?php endif; ?>
                                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php elseif(!empty($step->approver_role_id)): ?>
                                  <div class="small"><?php echo e($step->approverRole?->code ?? $step->approver_role_id); ?></div>
                                <?php else: ?>
                                  <span class="text-muted">—</span>
                                <?php endif; ?>
                              </td>
                            <td>
                                <form method="POST" action="<?php echo e(route('admin.steps.destroy',$step)); ?>" onsubmit="return confirm('Remove this step?');">
                                    <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                                    <button class="btn btn-outline-danger btn-sm"><i class="fa fa-trash"></i></button>
                                </form>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr><td colspan="4" class="text-muted">No steps yet.</td></tr>
                        <?php endif; ?>
                        
                        <tr>
                            <form method="POST" action="<?php echo e(route('admin.steps.store',$flow)); ?>">
                                <?php echo csrf_field(); ?>
                                <td>
                                  <input type="number" min="1" class="form-control form-control-sm" name="step_no" placeholder="auto">
                                  <div class="form-check mt-1">
                                    <input class="form-check-input" type="checkbox" name="require_all" id="require_all_<?php echo e($flow->id); ?>">
                                    <label class="form-check-label small" for="require_all_<?php echo e($flow->id); ?>">Require all approvers</label>
                                  </div>
                                </td>
                            
                                <td>
                                  <label class="small text-muted">Users (multi)</label>
                                  <select name="approver_user_ids[]" class="form-select form-select-sm" multiple size="4">
                                    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $u): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                      <option value="<?php echo e($u->id); ?>"><?php echo e($u->name); ?> (<?php echo e($u->email); ?>)</option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                  </select>
                                  <div class="form-text small">Hold Ctrl/Cmd to choose more than one.</div>
                                </td>
                            
                                <td>
                                  <label class="small text-muted">Roles (multi)</label>
                                  <select name="approver_role_ids[]" class="form-select form-select-sm" multiple size="4">
                                    <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                      <option value="<?php echo e($r->id); ?>"><?php echo e($r->code); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                  </select>
                                </td>
                            
                                <td class="align-middle">
                                  <button class="btn btn-success btn-sm"><i class="fa fa-plus"></i></button>
                                </td>
                              </form>
                        </tr>
                    </tbody>
                </table>
            </div>

            <div class="small text-muted">
                Tip: leave <em>Step</em> empty to append to the end. Provide either a user or a role.
            </div>
        </div>
    </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>

    <?php if($tab === 'users'): ?>
    <a id="users"></a>

    <div class="card card-rounded mb-3">
    <div class="card-header bg-primary text-white"><i class="fa fa-user-plus me-1"></i> Add / Upsert User</div>
    <div class="card-body">
        <form class="row g-3" method="POST" action="<?php echo e(route('admin.users.store')); ?>">
        <?php echo csrf_field(); ?>
        <div class="col-md-3">
            <label class="form-label">Name</label>
            <input name="name" class="form-control" placeholder="Full name" required>
        </div>
        <div class="col-md-4">
            <label class="form-label">Email</label>
            <input name="email" type="email" class="form-control" placeholder="user@yourtenant.onmicrosoft.com" required>
        </div>
        <div class="col-md-4">
            <label class="form-label">Notification Email(s) <small class="text-muted">(optional)</small></label>
            <input name="notify_email" type="text" class="form-control"
                    placeholder="e.g. alt@company.com or multiple separated by comma">
            <div class="form-text">You can enter multiple, separated by comma/semicolon/space.</div>
        </div>
        <div class="col-md-3">
            <label class="form-label">Role</label>
            <select name="role_id" class="form-select">
            <option value="">(none)</option>
            <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($r->id); ?>"><?php echo e($r->code); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>
        <div class="col-md-4">
          <label class="form-label">Companies</label>
          <select name="company_ids[]" class="form-select" multiple>
            <?php $__currentLoopData = $companies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <option value="<?php echo e($c->id); ?>"><?php echo e($c->code); ?> — <?php echo e($c->name); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </select>
          <div class="form-text">Hold Ctrl/Cmd to pick multiple.</div>
        </div>
                <div class="col-md-3">
          <label class="form-label">Company Codes (opt)</label>
          <input name="company_codes" class="form-control" placeholder="e.g. CI, TBI">
        </div>
        <div class="col-12">
            <button class="btn btn-primary"><i class="fa fa-save me-1"></i> Save</button>
        </div>
        </form>
        <div class="small text-muted mt-2">
        Users log in via Microsoft; adding them here just pre-creates the row and assigns a role.
        </div>
    </div>
    </div>

    <div class="card card-rounded">
    <div class="card-header bg-secondary text-white"><i class="fa fa-users me-1"></i> Users</div>
    <div class="card-body">
        <div class="table-responsive">
        <table class="table align-middle">
            <thead class="table-light">
                <tr>
                    <th>#</th>
                    <th>Name</th>
                    <th>Email</th>
                    <th>Notify Email</th>
                    <th>Company</th>
                    <th>Role</th>
                    <th>Change Role</th>   
                    <th>Edit</th>          
                    <th style="width:70px">Del</th>
                </tr>
                </thead>
                <tbody>
                <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $u): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                <td><?php echo e($u->id); ?></td>
                <td><?php echo e($u->name); ?></td>
                <td class="small text-muted"><?php echo e($u->email); ?></td>
                <td class="small text-muted"><?php echo e($u->notify_email ?: '—'); ?></td>
                <td class="small">
                    <?php $codes = $u->companies()->pluck('code')->all(); ?>
                    <?php echo e(empty($codes) ? '—' : implode(', ', $codes)); ?>

                </td>

                
                <td><span class="badge bg-dark"><?php echo e($u->role?->code ?? '—'); ?></span></td>
                <td>
                    <form class="d-flex gap-2" method="POST" action="<?php echo e(route('admin.users.updateRole',$u)); ?>">
                    <?php echo csrf_field(); ?>
                    <select name="role_id" class="form-select form-select-sm" style="max-width:200px">
                        <option value="">(none)</option>
                        <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($r->id); ?>" <?php echo e($u->role_id===$r->id?'selected':''); ?>><?php echo e($r->code); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <button class="btn btn-primary btn-sm"><i class="fa fa-save"></i></button>
                    </form>
                </td>
                <td>
                    <form class="d-flex flex-wrap gap-2 align-items-center"
                        method="POST" action="<?php echo e(route('admin.users.update', $u)); ?>">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PATCH'); ?>

                    <input name="name" class="form-control form-control-sm" style="max-width:180px"
                            value="<?php echo e(old('name',$u->name)); ?>">

                    <input name="notify_email" class="form-control form-control-sm" style="max-width:240px"
                            placeholder="alt1@x.com, alt2@x.com"
                            value="<?php echo e(old('notify_email',$u->notify_email)); ?>">

                    <select name="company_ids[]" class="form-select form-select-sm" style="max-width:260px" multiple>
                      <?php $__currentLoopData = $companies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($c->id); ?>" <?php echo e($u->companies->contains('id', $c->id) ? 'selected' : ''); ?>>
                          <?php echo e($c->code); ?> — <?php echo e($c->name); ?>

                        </option>
                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    
                    
                    <input name="company_codes" class="form-control form-control-sm" style="max-width:200px"
                           placeholder="CI, TBI">

                    <select name="role_id" class="form-select form-select-sm" style="max-width:180px">
                        <option value="">(none)</option>
                        <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($r->id); ?>" <?php echo e($u->role_id===$r->id?'selected':''); ?>><?php echo e($r->code); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>

                    <button class="btn btn-primary btn-sm"><i class="fa fa-save"></i></button>
                    </form>
                </td>

                
                <td>
                    <form method="POST" action="<?php echo e(route('admin.users.destroy',$u)); ?>" onsubmit="return confirm('Delete this user?');">
                    <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                    <button class="btn btn-outline-danger btn-sm"><i class="fa fa-trash"></i></button>
                    </form>
                </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
        </table>
        <?php echo e($users->withQueryString()->links()); ?>

        </div>
    </div>
    </div>
    <?php endif; ?>

    
    <?php if($tab === 'instances'): ?>
    <a id="instances"></a>
    <div class="card card-rounded">
        <div class="card-header bg-info text-white"><i class="fa fa-list-check me-1"></i>Approval Instances</div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table align-middle">
                    <thead class="table-light">
                        <tr>
                            <th>ID</th><th>Request #</th><th>Requester</th><th>Flow</th><th>Status</th><th>Step</th><th>Started</th><th>Completed</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $instances; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ins): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e($ins->id); ?></td>
                            <td>
                                <a href="<?php echo e(route('approvals.show', $ins->itemRequest?->id)); ?>" class="text-decoration-none">
                                    <span class="badge bg-secondary">#<?php echo e($ins->itemRequest?->id ?? '—'); ?></span>
                                </a>
                            </td>
                            <td><?php echo e($ins->itemRequest?->requester?->name); ?></td>
                            <td><?php echo e($ins->flow?->name); ?></td>
                            <td><span class="badge <?php echo e($ins->status==='InProgress'?'bg-warning':($ins->status==='Approved'?'bg-success':'bg-danger')); ?>"><?php echo e($ins->status); ?></span></td>
                            <td><?php echo e($ins->current_step_no); ?></td>
                            <td><?php echo e(optional($ins->started_at)->format('Y-m-d H:i')); ?></td>
                            <td><?php echo e(optional($ins->completed_at)->format('Y-m-d H:i')); ?></td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr><td colspan="8" class="text-muted">No instances.</td></tr>
                        <?php endif; ?>
                    </tbody>
                </table>
                <?php echo e($instances->withQueryString()->links()); ?>

            </div>
        </div>
    </div>
    <?php endif; ?>

    <?php if($tab === 'requests'): ?>
    <a id="requests"></a>
    <div class="card card-rounded">
    <div class="card-header bg-warning"><i class="fa fa-file-pen me-1"></i>Item Requests</div>
    <div class="card-body">
        <div class="table-responsive">
        <table class="table align-middle">
            <thead class="table-light">
            <tr>
                <th style="width:80px">ID</th>
                <th>Requester</th>
                <th>Status</th>
                <th style="width:90px">Step</th>
                <th>Flow</th>
                <th style="width:160px">Created</th>
                <th style="width:420px">Manage</th>
            </tr>
            </thead>
            <tbody>
            <?php $__empty_1 = true; $__currentLoopData = $requests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <?php
                $badge = match($r->status) {
                    'InReview' => 'bg-warning text-dark',
                    'Approved' => 'bg-success',
                    'Rejected' => 'bg-danger',
                    default => 'bg-secondary'
                };
                $max = \App\Models\ApprovalStepTemplate::where('flow_template_id',$r->flow_template_id)->max('step_no') ?? 0;
                ?>
                <tr>
                <td>
                    <a href="<?php echo e(route('approvals.show',$r->id)); ?>" class="text-decoration-none">
                    <span class="badge bg-secondary">#<?php echo e($r->id); ?></span>
                    </a>
                </td>
                <td><?php echo e($r->requester?->name); ?><div class="small text-muted"><?php echo e($r->requester?->email); ?></div></td>
                <td><span class="badge <?php echo e($badge); ?>"><?php echo e($r->status); ?></span></td>
                <td><span class="badge bg-info text-dark"><?php echo e($r->current_step_no ?: 0); ?> / <?php echo e($max); ?></span></td>
                <td><?php echo e($r->flow?->name); ?> <?php if($r->flow?->version): ?> v<?php echo e($r->flow->version); ?> <?php endif; ?></td>
                <td class="small text-muted"><?php echo e($r->created_at?->format('Y-m-d H:i')); ?></td>
                <td>
                    <div class="d-flex flex-wrap gap-2">
                    
                    <form method="POST" action="<?php echo e(route('admin.requests.reset',$r->id)); ?>">
                        <?php echo csrf_field(); ?>
                        <button class="btn btn-outline-secondary btn-sm" onclick="return confirm('Reset to Draft?')">
                        <i class="fa fa-rotate-left me-1"></i> Reset Draft
                        </button>
                    </form>

                    
                    <form method="POST" action="<?php echo e(route('admin.requests.jump',$r->id)); ?>" class="d-flex align-items-center gap-1">
                        <?php echo csrf_field(); ?>
                        <input type="number" name="step" min="1" class="form-control form-control-sm" style="width:80px"
                            value="<?php echo e(max(1,$r->current_step_no ?: 1)); ?>">
                        <button class="btn btn-outline-primary btn-sm">
                        <i class="fa fa-arrow-right-arrow-left me-1"></i> Jump
                        </button>
                    </form>

                    
                    <form method="POST" action="<?php echo e(route('admin.requests.forceApprove',$r->id)); ?>" class="d-flex align-items-center gap-1">
                        <?php echo csrf_field(); ?>
                        <input type="text" name="comment" class="form-control form-control-sm" placeholder="Comment">
                        <button class="btn btn-success btn-sm"><i class="fa fa-thumbs-up me-1"></i> Approve</button>
                    </form>

                    
                    <form method="POST" action="<?php echo e(route('admin.requests.forceReject',$r->id)); ?>" class="d-flex align-items-center gap-1">
                        <?php echo csrf_field(); ?>
                        <input type="text" name="comment" class="form-control form-control-sm" placeholder="Comment">
                        <button class="btn btn-danger btn-sm"><i class="fa fa-thumbs-down me-1"></i> Reject</button>
                    </form>

                    
                    <form method="POST" action="<?php echo e(route('admin.requests.destroy',$r->id)); ?>" onsubmit="return confirm('Delete this request permanently?')">
                        <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                        <button class="btn btn-outline-danger btn-sm"><i class="fa fa-trash me-1"></i> Delete</button>
                    </form>
                    </div>
                </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr><td colspan="7" class="text-muted">No requests.</td></tr>
            <?php endif; ?>
            </tbody>
        </table>
        <?php echo e($requests->withQueryString()->links()); ?>

        </div>
    </div>
    </div>
    <?php endif; ?>
    
    <?php if($tab === 'roles'): ?>
    <a id="roles"></a>
    
    <div class="card card-rounded mb-3">
      <div class="card-header bg-primary text-white">
        <i class="fa fa-plus me-1"></i> Add / Update Role
      </div>
      <div class="card-body">
        <form class="row g-3" method="POST" action="<?php echo e(route('admin.roles.store')); ?>">
          <?php echo csrf_field(); ?>
          <div class="col-md-4">
            <label class="form-label">Code</label>
            <input name="code" class="form-control" placeholder="ADMIN" required>
          </div>
          <div class="col-md-6">
              <label class="form-label">Name</label>
              <input name="name" class="form-control" placeholder="Administrator role">
            </div>
          <div class="col-12">
            <button class="btn btn-primary"><i class="fa fa-save me-1"></i> Save</button>
          </div>
        </form>
      </div>
    </div>
    
    <div class="card card-rounded">
      <div class="card-header bg-secondary text-white">
        <i class="fa fa-id-badge me-1"></i> Roles
      </div>
      <div class="card-body">
        <div class="table-responsive">
          <table class="table align-middle">
            <thead class="table-light">
              <tr>
                <th>#</th>
                <th>Code</th>
                <th>Description</th>
                <th style="width:100px">Action</th>
              </tr>
            </thead>
            <tbody>
              <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <tr>
                <td><?php echo e($role->id); ?></td>
                <td><?php echo e($role->code); ?></td>
                <td><?php echo e($role->name); ?></td>
                <td>
                  <form method="POST" action="<?php echo e(route('admin.roles.destroy',$role)); ?>" 
                        onsubmit="return confirm('Delete this role?');">
                    <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                    <button class="btn btn-outline-danger btn-sm">
                      <i class="fa fa-trash"></i>
                    </button>
                  </form>
                </td>
              </tr>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
          </table>
          <?php echo e($roles->withQueryString()->links()); ?>

        </div>
      </div>
    </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Lenovo\OneDrive\Documents\Kerjaan\stockopname\resources\views/admin/index.blade.php ENDPATH**/ ?>