<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use App\Services\AzureAuthService;
use Laravel\Socialite\Facades\Socialite;
use Illuminate\Support\Str;
use SocialiteProviders\Microsoft\Provider;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\User; 

class AzureAuthController extends Controller
{
    protected AzureAuthService $authService;

    public function __construct(AzureAuthService $authService)
    {
        $this->authService = $authService;
    }

    public function redirectToProvider()
    {
        return Socialite::driver('microsoft')
        ->scopes(['openid', 'offline_access', 'User.Read', 'Files.Read'])
        ->redirect();
    }

    public function handleProviderCallback(Request $request)
    {
        try {
            $user = Socialite::driver('microsoft')->stateless()->user(); 
            $email = strtolower($user->getEmail());
            $name  = $user->getName();
            $role = null;
        
            if (
                str_contains($email, 'adnyani') ||
                str_contains($email, 'titania')
            ) {
                $role = 'Regent';
            } elseif (
                str_contains($email, 'pebri') ||
                str_contains($email, 'pratiwi') ||
                str_contains($email, 'feybe')
            ) {
                $role = 'HIN';
            } elseif (
                str_contains($email, 'admin') ||
                str_contains($email, 'michael') ||
                str_contains($email, 'kristina') ||
                str_contains($email, 'costingho') ||
                str_contains($email, 'erlina')
            ) {
                $role = 'SUPER';
            } else {
                $role = 'Regent';
            }

            $local = User::firstOrCreate(['email' => $email], ['name' => $name]);
            Auth::login($local, true);         
            $request->session()->regenerate(); 
                    
            session([
                'user' => [
                    'name' => $user->getName(),
                    'email' => $user->getEmail(),
                    'role' => $role
                ],
                'graph' => [
                    'access_token'  => $user->token,
                    'refresh_token' => $user->refreshToken ?? null, // may be null if offline_access wasn’t granted earlier
                    'expires_at'    => now()->addSeconds((int)($user->expiresIn ?? 3600))->toIso8601String(),
                ],
            ]);
            return redirect('/approvals/my-forms');
        } catch (\Exception $e) {
            \Log::error('Socialite error: ' . $e->getMessage());
        }
    }


    public function logout()
    {
        $this->authService->clearSession();
        return redirect('/login');
    }
}

