<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class ApprovalInstance extends Model
{
    protected $fillable = [
        'item_request_id',
        'flow_template_id',
        'status',           
        'current_step_no',
        'started_at',
        'ended_at',
    ];

    protected $casts = [
        'started_at'   => 'datetime',
        'ended_at'   => 'datetime',
        'created_at'   => 'datetime',
        'updated_at'   => 'datetime',
    ];

    public function itemRequest(): BelongsTo
    {
        return $this->belongsTo(ItemRequest::class, 'item_request_id');
    }

    public function flow(): BelongsTo
    {
        return $this->belongsTo(ApprovalFlowTemplate::class, 'flow_template_id');
    }

    public function actions(): HasMany
    {
        return $this->hasMany(ApprovalAction::class, 'approval_instance_id');
    }
}