<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ApprovalStepApprover extends Model
{
    protected $fillable = ['step_template_id','approver_user_id','approver_role_id'];

    public function stepTemplate() {
        return $this->belongsTo(ApprovalStepTemplate::class, 'step_template_id');
    }

    public function user() {
        return $this->belongsTo(User::class, 'approver_user_id');
    }

    public function role() {
        return $this->belongsTo(Role::class, 'approver_role_id');
    }
}