<?php

namespace App\Models;
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ApprovalStepTemplate extends Model
{
    protected $fillable = [
        'flow_template_id',
        'step_no',
        'approver_user_id',
        'approver_role_id',
        'rule_json',
    ];

    protected $casts = [
        'rule_json' => 'array',
        'require_all' => 'boolean',
    ];

    public function flow(): BelongsTo
    {
        return $this->belongsTo(ApprovalFlowTemplate::class, 'flow_template_id');
    }

    public function approvers()
    {
        return $this->hasMany(\App\Models\ApprovalStepApprover::class, 'step_template_id');
    }

    public function approverUser(): BelongsTo
    {
        return $this->belongsTo(User::class, 'approver_user_id');
    }

    public function approverRole(): BelongsTo
    {
        return $this->belongsTo(Role::class, 'approver_role_id');
    }
}