<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
  public function up(): void {
    Schema::create('item_request_lines', function (Blueprint $t) {
      $t->id();
      $t->foreignId('item_request_id')->constrained()->cascadeOnDelete();
      $t->string('article_name');
      $t->enum('type',['Inventory','Service','NonInventory']);
      $t->string('base_unit_code');
      $t->string('gl_account_no')->nullable(); // NULL if Inventory
      $t->string('inventory_posting_group_code')->nullable();
      $t->string('gen_prod_posting_group_code')->nullable();
      $t->string('l1')->nullable();
      $t->string('l2')->nullable();
      $t->string('article_no')->nullable();
      $t->text('line_remarks')->nullable();
      $t->timestamps();
    });
  }
  public function down(): void { Schema::dropIfExists('item_request_lines'); }
};
