
<?php $__env->startSection('title','All Requests'); ?>

<?php $__env->startPush('styles'); ?>
<style>.card-rounded{border-radius:1rem}</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="container py-4">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h4 class="mb-0"><i class="fa fa-clipboard-list me-2"></i>All Requests</h4>
    <div class="d-flex gap-2">
      <a href="<?php echo e(route('approvals.mine')); ?>" class="btn btn-outline-secondary btn-sm">
        <i class="fa fa-inbox me-1"></i> My Forms
      </a>
      <a href="<?php echo e(route('approvals.new') ?? url('/approvals/new')); ?>" class="btn btn-primary btn-sm">
        <i class="fa fa-plus me-1"></i> New Item Request
      </a>
    </div>
  </div>

  <form class="row g-2 mb-3" method="GET" action="<?php echo e(route('approvals.all')); ?>">
      <div class="col-lg-4 col-md-6">
        <input type="text" name="q" value="<?php echo e($q ?? ''); ?>" class="form-control"
               placeholder="Search number, vendor, requester…">
      </div>
    
      <div class="col-lg-2 col-md-6">
        <select name="status" class="form-select">
          <option value="">Status (any)</option>
          <?php $__currentLoopData = ['Draft','InReview','Approved','Rejected']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $opt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($opt); ?>" <?php if(($status ?? '')===$opt): echo 'selected'; endif; ?>><?php echo e($opt); ?></option>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
      </div>
    
      <div class="col-lg-2 col-md-6">
        <input type="date" name="from" value="<?php echo e(request('from')); ?>" class="form-control" placeholder="From">
      </div>
    
      <div class="col-lg-2 col-md-6">
        <input type="date" name="to" value="<?php echo e(request('to')); ?>" class="form-control" placeholder="To">
      </div>
    
      <div class="col-lg-1 col-md-6">
        <button class="btn btn-primary w-100">
          <i class="fa fa-search me-1"></i> Filter
        </button>
      </div>
    
      <div class="col-lg-1 col-md-6">
        <a href="<?php echo e(route('approvals.all')); ?>" class="btn btn-outline-secondary w-100">Reset</a>
      </div>
    </form>

  <div class="card card-rounded shadow-sm">
    <div class="table-responsive">
      <table class="table align-middle">
        <thead class="table-light">
          <tr>
            <th style="width:70px">#</th>
            <th>Vendor</th>
            <th>Requester</th>
            <th>Flow</th>
            <th>Status</th>
            <th style="width:80px">Step</th>
            <th style="width:80px">Lines</th>
            <th style="width:140px">Posting Date</th>
            <th style="width:160px">Updated</th>
            <th style="width:90px">Open</th>
          </tr>
        </thead>
        <tbody>
        <?php $__empty_1 = true; $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
          <tr>
            <td><span class="badge bg-secondary">#<?php echo e($r->id); ?></span></td>
            <td><?php echo e($r->vendor_name ?? '—'); ?></td>
            <td>
              <?php echo e($r->requester?->name ?? '—'); ?>

              <?php if($r->requester?->email): ?>
                <div class="small text-muted"><?php echo e($r->requester->email); ?></div>
              <?php endif; ?>
            </td>
            <td>
              <?php echo e($r->flow?->name ?? '—'); ?>

              <?php if($r->flow?->version): ?> <span class="text-muted small">v<?php echo e($r->flow->version); ?></span> <?php endif; ?>
            </td>
            <td>
              <?php
                $cls = $r->status==='Approved' ? 'bg-success' :
                       ($r->status==='Rejected' ? 'bg-danger' :
                       ($r->status==='InReview' ? 'bg-warning text-dark' : 'bg-secondary'));
              ?>
              <span class="badge <?php echo e($cls); ?>"><?php echo e($r->status); ?></span>
            </td>
            <td><?php echo e($r->current_step_no ?? '—'); ?></td>
            <td><span class="badge bg-info"><?php echo e($r->lines_count); ?></span></td>
            <td><?php echo e(optional($r->posting_date)->format('Y-m-d') ?? '—'); ?></td>
            <td><?php echo e(optional($r->updated_at)->format('Y-m-d H:i')); ?></td>
            <td>
              <a href="<?php echo e(route('approvals.show', $r->id)); ?>" class="btn btn-outline-primary btn-sm">
                <i class="fa fa-eye me-1"></i> View
              </a>
            </td>
          </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
          <tr><td colspan="11" class="text-muted">No requests yet.</td></tr>
        <?php endif; ?>
        </tbody>
      </table>
    </div>
    <div class="p-3">
      <?php echo e($items->links()); ?>

    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/pawc5944/public_html/bc/resources/views/approvals/all.blade.php ENDPATH**/ ?>