<!-- borrower/dashboard.php -->
<?php
// Set page title
$page_title = "Dashboard";

// Include header
include '../template_borrower/header.php';

// Get borrower information
$borrower_id = $_SESSION['user_id'];

// Query untuk mengambil statistik borrower
// Total Peminjaman Aktif (status borrowed dan belum dikembalikan)
$query_active_loans = "SELECT COUNT(*) as total FROM transaction_items 
                       WHERE borrower_id = ? AND borrow_status = 'borrowed' AND actual_return_date IS NULL";
$stmt_active = $conn->prepare($query_active_loans);
$stmt_active->bind_param("i", $borrower_id);
$stmt_active->execute();
$result_active = $stmt_active->get_result();
$total_active_loans = $result_active->fetch_assoc()['total'];
$stmt_active->close();

// Total Peminjaman Menunggu Approval
$query_pending_loans = "SELECT COUNT(*) as total FROM transaction_items 
                        WHERE borrower_id = ? AND borrow_status = 'pending'";
$stmt_pending = $conn->prepare($query_pending_loans);
$stmt_pending->bind_param("i", $borrower_id);
$stmt_pending->execute();
$result_pending = $stmt_pending->get_result();
$total_pending_loans = $result_pending->fetch_assoc()['total'];
$stmt_pending->close();

// Total Peminjaman Selesai (sudah dikembalikan)
$query_completed_loans = "SELECT COUNT(*) as total FROM transaction_items 
                          WHERE borrower_id = ? AND borrow_status = 'returned'";
$stmt_completed = $conn->prepare($query_completed_loans);
$stmt_completed->bind_param("i", $borrower_id);
$stmt_completed->execute();
$result_completed = $stmt_completed->get_result();
$total_completed_loans = $result_completed->fetch_assoc()['total'];
$stmt_completed->close();

// Total Peminjaman Ditolak
$query_rejected_loans = "SELECT COUNT(*) as total FROM transaction_items 
                         WHERE borrower_id = ? AND borrow_status = 'rejected'";
$stmt_rejected = $conn->prepare($query_rejected_loans);
$stmt_rejected->bind_param("i", $borrower_id);
$stmt_rejected->execute();
$result_rejected = $stmt_rejected->get_result();
$total_rejected_loans = $result_rejected->fetch_assoc()['total'];
$stmt_rejected->close();
?>

<!-- Dashboard Content -->
<div class="w-full max-w-7xl mx-auto px-2 sm:px-4">
    <!-- Welcome Section -->
    <div class="bg-gradient-to-r from-purple-500 to-indigo-600 rounded-lg shadow-lg p-4 sm:p-6 mb-4 sm:mb-6 text-white">
        <div class="flex flex-col sm:flex-row items-start sm:items-center justify-between gap-4">
            <div class="w-full sm:w-auto">
                <h2 class="text-xl sm:text-2xl font-bold mb-2">Selamat Datang di Sistem Peminjaman Color Panel</h2>
                <p class="text-sm sm:text-base opacity-90 mb-1 break-words"><?php echo htmlspecialchars($_SESSION['nama_borrower']); ?></p>
                <div class="flex flex-col sm:flex-row sm:items-center gap-1 sm:gap-2 text-xs sm:text-sm opacity-75">
                    <span><?php echo htmlspecialchars($_SESSION['wc_code'] ?? '-'); ?> - <?php echo htmlspecialchars($_SESSION['wc_description'] ?? '-'); ?></span>
                    <span class="hidden sm:inline">|</span>
                    <span>NIK: <?php echo htmlspecialchars($_SESSION['nik']); ?></span>
                </div>
            </div>
            <div class="w-full sm:w-auto bg-white bg-opacity-20 rounded-lg p-3 text-center sm:text-right">
                <p class="text-xs opacity-75">Tanggal</p>
                <p class="text-base sm:text-lg font-semibold"><?php echo date('d M Y'); ?></p>
                <p class="text-xs opacity-75"><?php echo date('H:i'); ?> WIB</p>
            </div>
        </div>
    </div>

    <!-- Statistics Cards -->
    <div class="grid grid-cols-2 lg:grid-cols-4 gap-3 sm:gap-4 mb-4 sm:mb-6">
        <!-- Card 1: Peminjaman Aktif -->
        <div class="bg-white rounded-lg shadow-md p-3 sm:p-4 hover:shadow-lg transition-shadow duration-300 border-t-4 border-green-500">
            <div class="flex flex-col sm:flex-row items-start sm:items-center sm:justify-between gap-2">
                <div class="w-full">
                    <p class="text-gray-500 text-xs font-medium">Peminjaman Aktif</p>
                    <h3 class="text-xl sm:text-2xl font-bold text-gray-800 mt-1"><?php echo $total_active_loans; ?></h3>
                    <p class="text-xs text-green-500 mt-1">Sedang dipinjam</p>
                </div>
                <div class="bg-green-100 rounded-full p-2 sm:p-3 self-end sm:self-auto">
                    <i class="fas fa-hand-holding text-green-600 text-lg sm:text-xl"></i>
                </div>
            </div>
        </div>

        <!-- Card 2: Menunggu Approval -->
        <div class="bg-white rounded-lg shadow-md p-3 sm:p-4 hover:shadow-lg transition-shadow duration-300 border-t-4 border-yellow-500">
            <div class="flex flex-col sm:flex-row items-start sm:items-center sm:justify-between gap-2">
                <div class="w-full">
                    <p class="text-gray-500 text-xs font-medium">Menunggu Approval</p>
                    <h3 class="text-xl sm:text-2xl font-bold text-gray-800 mt-1"><?php echo $total_pending_loans; ?></h3>
                    <p class="text-xs text-yellow-500 mt-1">Pending</p>
                </div>
                <div class="bg-yellow-100 rounded-full p-2 sm:p-3 self-end sm:self-auto">
                    <i class="fas fa-clock text-yellow-600 text-lg sm:text-xl"></i>
                </div>
            </div>
        </div>

        <!-- Card 3: Peminjaman Selesai -->
        <div class="bg-white rounded-lg shadow-md p-3 sm:p-4 hover:shadow-lg transition-shadow duration-300 border-t-4 border-blue-500">
            <div class="flex flex-col sm:flex-row items-start sm:items-center sm:justify-between gap-2">
                <div class="w-full">
                    <p class="text-gray-500 text-xs font-medium">Peminjaman Selesai</p>
                    <h3 class="text-xl sm:text-2xl font-bold text-gray-800 mt-1"><?php echo $total_completed_loans; ?></h3>
                    <p class="text-xs text-blue-500 mt-1">Returned</p>
                </div>
                <div class="bg-blue-100 rounded-full p-2 sm:p-3 self-end sm:self-auto">
                    <i class="fas fa-check-circle text-blue-600 text-lg sm:text-xl"></i>
                </div>
            </div>
        </div>

        <!-- Card 4: Peminjaman Ditolak -->
        <div class="bg-white rounded-lg shadow-md p-3 sm:p-4 hover:shadow-lg transition-shadow duration-300 border-t-4 border-red-500">
            <div class="flex flex-col sm:flex-row items-start sm:items-center sm:justify-between gap-2">
                <div class="w-full">
                    <p class="text-gray-500 text-xs font-medium">Peminjaman Ditolak</p>
                    <h3 class="text-xl sm:text-2xl font-bold text-gray-800 mt-1"><?php echo $total_rejected_loans; ?></h3>
                    <p class="text-xs text-red-500 mt-1">Rejected</p>
                </div>
                <div class="bg-red-100 rounded-full p-2 sm:p-3 self-end sm:self-auto">
                    <i class="fas fa-times-circle text-red-600 text-lg sm:text-xl"></i>
                </div>
            </div>
        </div>
    </div>

    <!-- Quick Actions -->
    <div class="bg-white rounded-lg shadow-md p-4 sm:p-5 mb-4 sm:mb-6">
        <h3 class="text-base sm:text-lg font-bold text-gray-800 mb-3 flex items-center">
            <i class="fas fa-bolt text-purple-500 mr-2"></i>
            Quick Actions
        </h3>
        <div class="grid grid-cols-1 sm:grid-cols-2 gap-3 sm:gap-4">
            <a href="ajukan_peminjaman.php" class="flex items-center p-3 bg-gradient-to-r from-purple-50 to-purple-100 rounded-lg hover:from-purple-100 hover:to-purple-200 transition-all duration-200 border border-purple-200 group">
                <div class="bg-purple-500 rounded-full p-2 mr-3 flex-shrink-0">
                    <i class="fas fa-plus text-white text-base sm:text-lg"></i>
                </div>
                <div class="flex-1 min-w-0">
                    <p class="font-semibold text-gray-800 text-sm truncate">Ajukan Peminjaman</p>
                    <p class="text-xs text-gray-600 truncate">Pinjam color panel</p>
                </div>
                <i class="fas fa-arrow-right text-purple-500 ml-2 group-hover:translate-x-1 transition-transform flex-shrink-0"></i>
            </a>

            <a href="history_peminjaman.php" class="flex items-center p-3 bg-gradient-to-r from-blue-50 to-blue-100 rounded-lg hover:from-blue-100 hover:to-blue-200 transition-all duration-200 border border-blue-200 group">
                <div class="bg-blue-500 rounded-full p-2 mr-3 flex-shrink-0">
                    <i class="fas fa-history text-white text-base sm:text-lg"></i>
                </div>
                <div class="flex-1 min-w-0">
                    <p class="font-semibold text-gray-800 text-sm truncate">History Peminjaman</p>
                    <p class="text-xs text-gray-600 truncate">Lihat riwayat</p>
                </div>
                <i class="fas fa-arrow-right text-blue-500 ml-2 group-hover:translate-x-1 transition-transform flex-shrink-0"></i>
            </a>
        </div>
    </div>

    <!-- Information Box -->
    <div class="bg-gradient-to-r from-indigo-50 to-purple-50 rounded-lg shadow-md p-4 sm:p-5 border border-indigo-200">
        <div class="flex flex-col sm:flex-row items-start gap-3">
            <div class="bg-indigo-500 rounded-full p-2 flex-shrink-0">
                <i class="fas fa-info-circle text-white text-base sm:text-lg"></i>
            </div>
            <div class="flex-1 min-w-0">
                <h3 class="text-sm sm:text-base font-bold text-gray-800 mb-2">Informasi Sistem</h3>
                <p class="text-gray-600 text-xs sm:text-sm mb-3">
                    Sistem Peminjaman Color Panel memudahkan Anda untuk meminjam color panel furniture dengan proses yang cepat dan terkelola.
                </p>
                <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-2">
                    <div class="flex items-start sm:items-center text-xs text-gray-700">
                        <i class="fas fa-check-circle text-green-500 mr-2 mt-0.5 sm:mt-0 flex-shrink-0"></i>
                        <span>Proses cepat & mudah</span>
                    </div>
                    <div class="flex items-start sm:items-center text-xs text-gray-700">
                        <i class="fas fa-check-circle text-green-500 mr-2 mt-0.5 sm:mt-0 flex-shrink-0"></i>
                        <span>Tracking real-time</span>
                    </div>
                    <div class="flex items-start sm:items-center text-xs text-gray-700">
                        <i class="fas fa-check-circle text-green-500 mr-2 mt-0.5 sm:mt-0 flex-shrink-0"></i>
                        <span>Riwayat tersimpan aman</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php
// Include footer
include '../template_borrower/footer.php';
?>