<?php
// Set page title
$page_title = "Master Work Center";

// Include header
include '../template_it/header.php';

// Get all WC data
$query = "SELECT * FROM wc_master ORDER BY category ASC, wc_code ASC";
$result = $conn->query($query);
?>

<style>
.wc-card {
    transition: all 0.3s ease;
}

.wc-card:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(0,0,0,0.1);
}

.category-painting {
    background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
}

.category-packing {
    background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
}

.action-btn {
    transition: all 0.2s ease;
}

.action-btn:hover {
    transform: scale(1.05);
}

.status-active {
    background-color: #d4edda;
    color: #155724;
}

.status-inactive {
    background-color: #f8d7da;
    color: #721c24;
}
</style>

<div class="container mx-auto">
    <!-- Page Header -->
    <div class="bg-white rounded-lg shadow-md p-6 mb-6">
        <div class="flex items-center justify-between">
            <div>
                <h2 class="text-2xl font-bold text-gray-800">
                    <i class="fas fa-industry text-blue-600 mr-2"></i>
                    Master Work Center
                </h2>
                <p class="text-gray-600 mt-1">Kelola data master Work Center codes dan descriptions</p>
            </div>
            <button 
                onclick="showAddWcModal()" 
                class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-3 rounded-lg font-semibold transition-colors">
                <i class="fas fa-plus mr-2"></i>Tambah Work Center
            </button>
        </div>
    </div>

    <!-- Statistics -->
    <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-6">
        <div class="bg-white rounded-lg shadow-md p-6">
            <div class="flex items-center">
                <div class="bg-blue-100 p-3 rounded-full">
                    <i class="fas fa-list text-blue-600 text-xl"></i>
                </div>
                <div class="ml-4">
                    <p class="text-gray-600 text-sm">Total WC</p>
                    <p class="text-2xl font-bold text-gray-800"><?php echo $result->num_rows; ?></p>
                </div>
            </div>
        </div>
        
        <div class="bg-white rounded-lg shadow-md p-6">
            <div class="flex items-center">
                <div class="bg-green-100 p-3 rounded-full">
                    <i class="fas fa-check-circle text-green-600 text-xl"></i>
                </div>
                <div class="ml-4">
                    <p class="text-gray-600 text-sm">Active WC</p>
                    <p class="text-2xl font-bold text-gray-800">
                        <?php 
                        $result->data_seek(0);
                        $active_count = 0;
                        while($row = $result->fetch_assoc()) {
                            if($row['is_active'] == 1) {
                                $active_count++;
                            }
                        }
                        echo $active_count;
                        ?>
                    </p>
                </div>
            </div>
        </div>
        
        <div class="bg-white rounded-lg shadow-md p-6">
            <div class="flex items-center">
                <div class="bg-purple-100 p-3 rounded-full">
                    <i class="fas fa-paint-brush text-purple-600 text-xl"></i>
                </div>
                <div class="ml-4">
                    <p class="text-gray-600 text-sm">Painting WC</p>
                    <p class="text-2xl font-bold text-gray-800">
                        <?php 
                        $result->data_seek(0);
                        $painting_count = 0;
                        while($row = $result->fetch_assoc()) {
                            if($row['category'] == 'PAINTING') {
                                $painting_count++;
                            }
                        }
                        echo $painting_count;
                        ?>
                    </p>
                </div>
            </div>
        </div>
        
        <div class="bg-white rounded-lg shadow-md p-6">
            <div class="flex items-center">
                <div class="bg-orange-100 p-3 rounded-full">
                    <i class="fas fa-box text-orange-600 text-xl"></i>
                </div>
                <div class="ml-4">
                    <p class="text-gray-600 text-sm">Packing WC</p>
                    <p class="text-2xl font-bold text-gray-800">
                        <?php 
                        $result->data_seek(0);
                        $packing_count = 0;
                        while($row = $result->fetch_assoc()) {
                            if($row['category'] == 'PACKING') {
                                $packing_count++;
                            }
                        }
                        echo $packing_count;
                        ?>
                    </p>
                </div>
            </div>
        </div>
    </div>

    <!-- WC List -->
    <div class="bg-white rounded-lg shadow-md">
        <div class="p-6 border-b border-gray-200">
            <h3 class="text-lg font-semibold text-gray-800">
                <i class="fas fa-list mr-2"></i>Daftar Work Center
            </h3>
        </div>
        
        <div class="p-6">
            <?php if($result->num_rows > 0): ?>
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                    <?php 
                    $result->data_seek(0);
                    while($wc = $result->fetch_assoc()): 
                        $category_class = $wc['category'] == 'PAINTING' ? 'category-painting' : 'category-packing';
                    ?>
                        <div class="wc-card bg-gray-50 rounded-lg p-4 border border-gray-200">
                            <div class="flex items-start justify-between mb-3">
                                <div class="flex-1">
                                    <div class="flex items-center gap-2 mb-2">
                                        <span class="bg-blue-600 text-white px-3 py-1 rounded-full text-sm font-bold">
                                            <?php echo htmlspecialchars($wc['wc_code']); ?>
                                        </span>
                                        <div class="<?php echo $wc['is_active'] ? 'status-active' : 'status-inactive'; ?> px-2 py-1 rounded text-xs font-semibold">
                                            <?php echo $wc['is_active'] ? 'Active' : 'Inactive'; ?>
                                        </div>
                                    </div>
                                    <h4 class="font-semibold text-gray-800 text-sm mb-2">
                                        <?php echo htmlspecialchars($wc['wc_description']); ?>
                                    </h4>
                                    <div class="<?php echo $category_class; ?> text-white px-2 py-1 rounded text-xs font-semibold inline-block">
                                        <?php echo $wc['category']; ?>
                                    </div>
                                </div>
                                <div class="flex gap-1">
                                    <button 
                                        onclick="editWc(<?php echo $wc['id']; ?>)"
                                        class="action-btn bg-blue-500 hover:bg-blue-600 text-white p-2 rounded text-sm"
                                        title="Edit">
                                        <i class="fas fa-edit"></i>
                                    </button>
                                    <button 
                                        onclick="deleteWc(<?php echo $wc['id']; ?>, '<?php echo htmlspecialchars(addslashes($wc['wc_code'])); ?>')"
                                        class="action-btn bg-red-500 hover:bg-red-600 text-white p-2 rounded text-sm"
                                        title="Hapus">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </div>
                            </div>
                            
                            <div class="text-xs text-gray-500">
                                <i class="fas fa-calendar mr-1"></i>
                                Dibuat: <?php echo date('d/m/Y', strtotime($wc['created_at'])); ?>
                            </div>
                        </div>
                    <?php endwhile; ?>
                </div>
            <?php else: ?>
                <div class="text-center py-12">
                    <i class="fas fa-industry text-gray-300 text-6xl mb-4"></i>
                    <p class="text-gray-500 text-lg">Belum ada data Work Center</p>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- Modal: Tambah WC -->
<div id="addWcModal" class="hidden fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50">
    <div class="relative top-20 mx-auto p-5 border w-full max-w-lg shadow-lg rounded-lg bg-white">
        <div class="flex items-center justify-between mb-4 border-b pb-3">
            <h3 class="text-xl font-bold text-gray-800">
                <i class="fas fa-plus-circle text-blue-600 mr-2"></i>
                Tambah Work Center
            </h3>
            <button onclick="closeAddWcModal()" class="text-gray-400 hover:text-gray-600">
                <i class="fas fa-times text-2xl"></i>
            </button>
        </div>

        <form id="formAddWc" onsubmit="submitAddWc(event)">
            <div class="mb-4">
                <label class="block text-gray-700 font-semibold mb-2">
                    WC Code <span class="text-red-500">*</span>
                </label>
                <input 
                    type="text" 
                    id="addWcCode" 
                    name="wc_code"
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500"
                    placeholder="Contoh: WC261"
                    maxlength="10"
                    required>
            </div>

            <div class="mb-4">
                <label class="block text-gray-700 font-semibold mb-2">
                    WC Description <span class="text-red-500">*</span>
                </label>
                <input 
                    type="text" 
                    id="addWcDescription" 
                    name="wc_description"
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500"
                    placeholder="Contoh: CGD PAINTING A1"
                    maxlength="100"
                    required>
            </div>

            <div class="mb-6">
                <label class="block text-gray-700 font-semibold mb-2">
                    Category <span class="text-red-500">*</span>
                </label>
                <select 
                    id="addCategory" 
                    name="category"
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500"
                    required>
                    <option value="">-- Pilih Category --</option>
                    <option value="PAINTING">PAINTING</option>
                    <option value="PACKING">PACKING</option>
                </select>
            </div>

            <div class="flex gap-3">
                <button 
                    type="submit" 
                    class="flex-1 bg-blue-600 hover:bg-blue-700 text-white font-bold py-3 px-4 rounded-lg transition-colors">
                    <i class="fas fa-save mr-2"></i> Simpan WC
                </button>
                <button 
                    type="button" 
                    onclick="closeAddWcModal()"
                    class="flex-1 bg-gray-400 hover:bg-gray-500 text-white font-bold py-3 px-4 rounded-lg transition-colors">
                    <i class="fas fa-times mr-2"></i> Batal
                </button>
            </div>
        </form>
    </div>
</div>

<!-- Modal: Edit WC -->
<div id="editWcModal" class="hidden fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50">
    <div class="relative top-20 mx-auto p-5 border w-full max-w-lg shadow-lg rounded-lg bg-white">
        <div class="flex items-center justify-between mb-4 border-b pb-3">
            <h3 class="text-xl font-bold text-gray-800">
                <i class="fas fa-edit text-blue-600 mr-2"></i>
                Edit Work Center
            </h3>
            <button onclick="closeEditWcModal()" class="text-gray-400 hover:text-gray-600">
                <i class="fas fa-times text-2xl"></i>
            </button>
        </div>

        <form id="formEditWc" onsubmit="submitEditWc(event)">
            <input type="hidden" id="editWcId" name="wc_id">
            
            <div class="mb-4">
                <label class="block text-gray-700 font-semibold mb-2">
                    WC Code <span class="text-red-500">*</span>
                </label>
                <input 
                    type="text" 
                    id="editWcCode" 
                    name="wc_code"
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500"
                    maxlength="10"
                    required>
            </div>

            <div class="mb-4">
                <label class="block text-gray-700 font-semibold mb-2">
                    WC Description <span class="text-red-500">*</span>
                </label>
                <input 
                    type="text" 
                    id="editWcDescription" 
                    name="wc_description"
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500"
                    maxlength="100"
                    required>
            </div>

            <div class="mb-4">
                <label class="block text-gray-700 font-semibold mb-2">
                    Category <span class="text-red-500">*</span>
                </label>
                <select 
                    id="editCategory" 
                    name="category"
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500"
                    required>
                    <option value="PAINTING">PAINTING</option>
                    <option value="PACKING">PACKING</option>
                </select>
            </div>

            <div class="mb-6">
                <label class="block text-gray-700 font-semibold mb-2">
                    Status <span class="text-red-500">*</span>
                </label>
                <select 
                    id="editIsActive" 
                    name="is_active"
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500"
                    required>
                    <option value="1">Active</option>
                    <option value="0">Inactive</option>
                </select>
            </div>

            <div class="flex gap-3">
                <button 
                    type="submit" 
                    class="flex-1 bg-blue-600 hover:bg-blue-700 text-white font-bold py-3 px-4 rounded-lg transition-colors">
                    <i class="fas fa-save mr-2"></i> Update WC
                </button>
                <button 
                    type="button" 
                    onclick="closeEditWcModal()"
                    class="flex-1 bg-gray-400 hover:bg-gray-500 text-white font-bold py-3 px-4 rounded-lg transition-colors">
                    <i class="fas fa-times mr-2"></i> Batal
                </button>
            </div>
        </form>
    </div>
</div>

<script>
// Modal Add WC
function showAddWcModal() {
    document.getElementById('addWcModal').classList.remove('hidden');
}

function closeAddWcModal() {
    document.getElementById('addWcModal').classList.add('hidden');
    document.getElementById('formAddWc').reset();
}

function submitAddWc(event) {
    event.preventDefault();
    
    const formData = new FormData(event.target);
    const params = new URLSearchParams();
    for (const pair of formData.entries()) {
        params.append(pair[0], pair[1]);
    }
    params.append('action', 'add_wc');
    
    fetch('process_wc.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded',
        },
        body: params.toString()
    })
    .then(response => response.json())
    .then(data => {
        if(data.success) {
            alert('Work Center berhasil ditambahkan!');
            location.reload();
        } else {
            alert('Error: ' + data.message);
        }
    })
    .catch(error => {
        alert('Error: ' + error);
    });
}

// Modal Edit WC
function editWc(wcId) {
    fetch(`get_wc.php?id=${wcId}`)
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                document.getElementById('editWcId').value = data.wc.id;
                document.getElementById('editWcCode').value = data.wc.wc_code;
                document.getElementById('editWcDescription').value = data.wc.wc_description;
                document.getElementById('editCategory').value = data.wc.category;
                document.getElementById('editIsActive').value = data.wc.is_active;
                
                document.getElementById('editWcModal').classList.remove('hidden');
            } else {
                alert('Error: ' + data.message);
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('Error loading WC data');
        });
}

function closeEditWcModal() {
    document.getElementById('editWcModal').classList.add('hidden');
    document.getElementById('formEditWc').reset();
}

function submitEditWc(event) {
    event.preventDefault();
    
    const formData = new FormData(event.target);
    const params = new URLSearchParams();
    for (const pair of formData.entries()) {
        params.append(pair[0], pair[1]);
    }
    params.append('action', 'edit_wc');
    
    fetch('process_wc.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded',
        },
        body: params.toString()
    })
    .then(response => response.json())
    .then(data => {
        if(data.success) {
            alert('Work Center berhasil diupdate!');
            location.reload();
        } else {
            alert('Error: ' + data.message);
        }
    })
    .catch(error => {
        alert('Error: ' + error);
    });
}

// Delete WC
function deleteWc(wcId, wcCode) {
    if(confirm(`Hapus Work Center "${wcCode}"?`)) {
        fetch('process_wc.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded',
            },
            body: `action=delete_wc&wc_id=${wcId}`
        })
        .then(response => response.json())
        .then(data => {
            if(data.success) {
                alert('Work Center berhasil dihapus!');
                location.reload();
            } else {
                alert('Error: ' + data.message);
            }
        })
        .catch(error => {
            alert('Error: ' + error);
        });
    }
}
</script>

<?php
include '../template_it/footer.php';
?>