<?php
require_once '../config/connection.php';
require_once '../vendor/autoload.php';

use chillerlan\QRCode\QRCode;
use chillerlan\QRCode\QROptions;

header('Content-Type: application/json');

$master_color_id = isset($_GET['master_color_id']) ? (int)$_GET['master_color_id'] : 0;

if ($master_color_id <= 0) {
    echo json_encode(['success' => false, 'message' => 'Invalid Master Color ID']);
    exit;
}

try {
    $query = "
        SELECT 
            mc.id,
            mc.code_color as master_code,
            mc.color_name,
            mc.qr_code,
            mc.manufacturing_date,
            mc.expired_date,
            mc.lemari,
            mc.lemari_number,
            mc.created_at,
            b.nama_buyer,
            b.kode_buyer,
            c.nama_collection
        FROM master_color mc
        LEFT JOIN buyers b ON mc.buyer_id = b.id
        LEFT JOIN collections c ON mc.collection_id = c.id
        WHERE mc.id = $master_color_id
        LIMIT 1
    ";
    
    $result = $conn->query($query);
    
    if (!$result || $result->num_rows == 0) {
        echo json_encode(['success' => false, 'message' => 'Master Color tidak ditemukan']);
        exit;
    }
    
    $row = $result->fetch_assoc();
    $master_code = $row['master_code'];
    
    // Create fresh QR instance untuk menghindari data terbawa
    $options = new QROptions([
        'version'    => 5,
        'outputType' => QRCode::OUTPUT_IMAGE_PNG,
        'eccLevel'   => QRCode::ECC_L,
        'scale'      => 10,
        'imageBase64' => true,
    ]);
    
    $qrcode = new QRCode($options);
    
    // Clean master code sebelum generate
    $clean_master_code = trim($master_code);
    $qr_image = $qrcode->render($clean_master_code);
    
    // Update QR code ke database
    $qr_escaped = $conn->real_escape_string($qr_image);
    $update_query = "UPDATE master_color SET qr_code = '$qr_escaped' WHERE id = $master_color_id";
    $conn->query($update_query);
    
    // Format tanggal untuk response
    $mfg_date = !empty($row['manufacturing_date']) ? date('d-m-Y', strtotime($row['manufacturing_date'])) : '-';
    $exp_date = !empty($row['expired_date']) ? date('d-m-Y', strtotime($row['expired_date'])) : '-';
    
    echo json_encode([
        'success' => true,
        'master_code' => $master_code,
        'color_name' => $row['color_name'],
        'buyer_name' => $row['nama_buyer'],
        'kode_buyer' => $row['kode_buyer'],
        'collection_name' => $row['nama_collection'],
        'manufacturing_date' => $mfg_date,
        'expired_date' => $exp_date,
        'lemari' => $row['lemari'],
        'lemari_number' => $row['lemari_number'],
        'qr_image' => $qr_image
    ]);
    
    // Clear memory
    unset($qrcode);
    unset($options);
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Error: ' . $e->getMessage()]);
}

$conn->close();
?>