<?php
require_once '../config/connection.php';

header('Content-Type: application/json');

$master_code = isset($_GET['master_code']) ? $conn->real_escape_string($_GET['master_code']) : '';

if (empty($master_code)) {
    echo json_encode(['success' => false, 'message' => 'Master code is required']);
    exit;
}

try {
    $query = "
        SELECT 
            mc.id,
            mc.code_color as master_code,
            mc.color_name,
            mc.lemari,
            mc.lemari_number,
            mc.created_at,
            b.nama_buyer,
            b.kode_buyer,
            c.nama_collection,
            mcp.panel_code,
            mcp.rack_number,
            COUNT(csi.id) as total_stock_items,
            COUNT(CASE WHEN csi.status = 'available' THEN 1 END) as available_items,
            COUNT(CASE WHEN csi.status = 'borrowed' THEN 1 END) as borrowed_items,
            COUNT(CASE WHEN csi.status = 'expired' THEN 1 END) as expired_items
        FROM master_color mc
        LEFT JOIN buyers b ON mc.buyer_id = b.id
        LEFT JOIN collections c ON mc.collection_id = c.id
        LEFT JOIN master_color_panel mcp ON mc.id = mcp.master_color_id
        LEFT JOIN color_stock_items csi ON mc.id = csi.master_color_id
        WHERE mc.code_color = '$master_code'
        GROUP BY mc.id
        LIMIT 1
    ";
    
    $result = $conn->query($query);
    
    if ($result && $result->num_rows > 0) {
        $row = $result->fetch_assoc();
        
        // Get components
        $components_query = "
            SELECT DISTINCT
                cc.component_name,
                COUNT(csi.id) as total_count,
                COUNT(CASE WHEN csi.status = 'available' THEN 1 END) as available_count
            FROM color_components cc
            LEFT JOIN color_stock_items csi ON cc.id = csi.component_id AND csi.master_color_id = {$row['id']}
            WHERE EXISTS (
                SELECT 1 FROM color_stock_items csi2 
                WHERE csi2.component_id = cc.id AND csi2.master_color_id = {$row['id']}
            )
            GROUP BY cc.id, cc.component_name
            ORDER BY cc.component_name ASC
        ";
        
        $components_result = $conn->query($components_query);
        $components = [];
        
        if ($components_result && $components_result->num_rows > 0) {
            while ($comp_row = $components_result->fetch_assoc()) {
                $components[] = [
                    'component_name' => $comp_row['component_name'],
                    'total_count' => (int)$comp_row['total_count'],
                    'available_count' => (int)$comp_row['available_count']
                ];
            }
        }
        
        $location_info = '';
        if (!empty($row['lemari']) && !empty($row['lemari_number'])) {
            $location_info = $row['lemari'] . ' ' . str_pad($row['lemari_number'], 3, '0', STR_PAD_LEFT);
        }
        
        $rack_info = '';
        if (!empty($row['rack_number'])) {
            $rack_info = 'Rack ' . str_pad($row['rack_number'], 3, '0', STR_PAD_LEFT);
        }
        
        // Format tanggal
        $created_date = $row['created_at'] ? date('d-m-Y', strtotime($row['created_at'])) : null;
        
        echo json_encode([
            'success' => true,
            'master_detail' => [
                'master_code' => $row['master_code'], // Code color master
                'color_name' => $row['color_name'],   // Nama color
                'buyer_name' => $row['nama_buyer'],
                'buyer_code' => $row['kode_buyer'],
                'collection_name' => $row['nama_collection'],
                'panel_code' => $row['panel_code'],
                'location_info' => $location_info,
                'rack_info' => $rack_info,
                'created_date' => $created_date,
                'stock_summary' => [
                    'total_items' => (int)$row['total_stock_items'],
                    'available_items' => (int)$row['available_items'],
                    'borrowed_items' => (int)$row['borrowed_items'],
                    'expired_items' => (int)$row['expired_items']
                ],
                'components' => $components
            ]
        ]);
    } else {
        echo json_encode(['success' => false, 'message' => 'Master color not found']);
    }
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Error: ' . $e->getMessage()]);
}

$conn->close();
?>