<?php
require_once '../config/connection.php';

header('Content-Type: application/json');

$master_code = isset($_GET['master_code']) ? $conn->real_escape_string($_GET['master_code']) : '';

if (empty($master_code)) {
    echo json_encode(['success' => false, 'message' => 'Master code is required']);
    exit;
}

try {
    $query = "
        SELECT 
            mc.code_color as master_code,
            mc.color_name,
            mc.qr_code,
            mc.manufacturing_date,
            mc.expired_date,
            mc.lemari,
            mc.lemari_number,
            mc.created_at,
            b.nama_buyer,
            b.kode_buyer,
            c.nama_collection
        FROM master_color mc
        LEFT JOIN buyers b ON mc.buyer_id = b.id
        LEFT JOIN collections c ON mc.collection_id = c.id
        WHERE mc.code_color = '$master_code'
        LIMIT 1
    ";
    
    $result = $conn->query($query);
    
    if ($result && $result->num_rows > 0) {
        $row = $result->fetch_assoc();
        
        if (!empty($row['qr_code'])) {
            // Format tanggal
            $mfg_date = !empty($row['manufacturing_date']) ? date('d-m-Y', strtotime($row['manufacturing_date'])) : '-';
            $exp_date = !empty($row['expired_date']) ? date('d-m-Y', strtotime($row['expired_date'])) : '-';
            
            echo json_encode([
                'success' => true,
                'master_code' => $row['master_code'],
                'color_name' => $row['color_name'],
                'buyer_name' => $row['nama_buyer'],
                'kode_buyer' => $row['kode_buyer'],
                'collection_name' => $row['nama_collection'],
                'manufacturing_date' => $mfg_date,
                'expired_date' => $exp_date,
                'lemari' => $row['lemari'],
                'lemari_number' => $row['lemari_number'],
                'qr_image' => $row['qr_code']
            ]);
        } else {
            echo json_encode(['success' => false, 'message' => 'QR Code belum di-generate']);
        }
    } else {
        echo json_encode(['success' => false, 'message' => 'Master color not found']);
    }
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Error: ' . $e->getMessage()]);
}

$conn->close();
?>