<?php
session_start();
require_once '../config/connection.php';

// Check if user is logged in
if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] != 'it') {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit();
}

header('Content-Type: application/json');

// Get parameters
if (!isset($_GET['buyer_id'])) {
    echo json_encode(['success' => false, 'message' => 'Missing parameters']);
    exit();
}

$buyer_id = intval($_GET['buyer_id']);

// Get the highest code from all tables (global sequence)
$next_number = 1;
$max_number = 0;

// Query untuk mendapatkan nomor tertinggi dari semua tabel
$queries = [
    "SELECT CAST(code_color AS UNSIGNED) as num FROM master_color WHERE code_color REGEXP '^[0-9]+$' ORDER BY CAST(code_color AS UNSIGNED) DESC LIMIT 1",
    "SELECT CAST(panel_code AS UNSIGNED) as num FROM master_color_panel WHERE panel_code REGEXP '^[0-9]+$' ORDER BY CAST(panel_code AS UNSIGNED) DESC LIMIT 1",
    "SELECT CAST(code_color AS UNSIGNED) as num FROM color_stock_items WHERE code_color REGEXP '^[0-9]+$' ORDER BY CAST(code_color AS UNSIGNED) DESC LIMIT 1"
];

foreach ($queries as $query) {
    $result = $conn->query($query);
    if ($result && $result->num_rows > 0) {
        $row = $result->fetch_assoc();
        $current_num = intval($row['num']);
        if ($current_num > $max_number) {
            $max_number = $current_num;
        }
    }
}

$next_number = $max_number + 1;

// Format: 00001, 00002, 00003, etc. (5 digits)
$next_code = str_pad($next_number, 5, '0', STR_PAD_LEFT);

echo json_encode([
    'success' => true,
    'code_color' => $next_code,
    'next_number' => $next_number
]);

$conn->close();
?>