<?php
session_start();
require_once '../config/connection.php';

// Check if user is logged in
if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] != 'it') {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit();
}

header('Content-Type: application/json');

$action = isset($_POST['action']) ? $_POST['action'] : '';

$conn->begin_transaction();

try {
    switch($action) {
        case 'add_borrower':
            $username = isset($_POST['username']) ? $conn->real_escape_string(trim($_POST['username'])) : '';
            $nama_borrower = isset($_POST['nama_borrower']) ? $conn->real_escape_string(trim($_POST['nama_borrower'])) : '';
            $nik = isset($_POST['nik']) ? $conn->real_escape_string(trim($_POST['nik'])) : '';
            $password = isset($_POST['password']) ? trim($_POST['password']) : '';
            $email = isset($_POST['email']) ? $conn->real_escape_string(trim($_POST['email'])) : '';
            $wc_id = isset($_POST['wc_id']) ? (int)$_POST['wc_id'] : 0;
            
            if (empty($username) || empty($nama_borrower) || empty($nik) || empty($password) || $wc_id <= 0) {
                throw new Exception('Field username, nama borrower, NIK, password, dan Work Center wajib diisi');
            }
            
            // Check if username already exists
            $check_username = "SELECT id FROM borrower_users WHERE username = '$username'";
            $check_result = $conn->query($check_username);
            
            if($check_result->num_rows > 0) {
                throw new Exception('Username sudah digunakan');
            }
            
            // Check if NIK already exists
            $check_nik = "SELECT id FROM borrower_users WHERE nik = '$nik'";
            $check_result = $conn->query($check_nik);
            
            if($check_result->num_rows > 0) {
                throw new Exception('NIK sudah digunakan');
            }
            
            // Check if WC already assigned to another user
            $check_wc = "SELECT id FROM borrower_users WHERE wc_id = $wc_id";
            $check_result = $conn->query($check_wc);
            
            if($check_result->num_rows > 0) {
                throw new Exception('Work Center sudah dimiliki user lain');
            }
            
            // Check if WC ID exists and is active
            $check_wc_master = "SELECT id FROM wc_master WHERE id = $wc_id AND is_active = 1";
            $check_result = $conn->query($check_wc_master);
            
            if($check_result->num_rows == 0) {
                throw new Exception('Work Center tidak valid atau tidak aktif');
            }
            
            // Hash password
            $hashed_password = password_hash($password, PASSWORD_DEFAULT);
            
            $query = "INSERT INTO borrower_users (username, nama_borrower, nik, password, email, wc_id, status, created_at) 
                     VALUES ('$username', '$nama_borrower', '$nik', '$hashed_password', '$email', $wc_id, 'active', NOW())";
            
            if(!$conn->query($query)) {
                throw new Exception($conn->error);
            }
            
            $conn->commit();
            
            // Log audit
            $audit_query = "INSERT INTO audit_logs (action_type, user_id, user_type, details, timestamp, ip_address) 
                           VALUES ('ADD_BORROWER_USER', ?, 'it', ?, NOW(), ?)";
            $audit_stmt = $conn->prepare($audit_query);
            $user_id = $_SESSION['user_id'];
            $audit_details = "Added borrower user: $nama_borrower ($username - WC ID: $wc_id)";
            $ip_address = $_SERVER['REMOTE_ADDR'];
            $audit_stmt->bind_param("iss", $user_id, $audit_details, $ip_address);
            $audit_stmt->execute();
            $audit_stmt->close();
            
            echo json_encode(['success' => true, 'message' => 'Borrower berhasil ditambahkan']);
            break;
            
        case 'edit_borrower':
            $borrower_id = isset($_POST['borrower_id']) ? (int)$_POST['borrower_id'] : 0;
            $username = isset($_POST['username']) ? $conn->real_escape_string(trim($_POST['username'])) : '';
            $nama_borrower = isset($_POST['nama_borrower']) ? $conn->real_escape_string(trim($_POST['nama_borrower'])) : '';
            $nik = isset($_POST['nik']) ? $conn->real_escape_string(trim($_POST['nik'])) : '';
            $password = isset($_POST['password']) ? trim($_POST['password']) : '';
            $email = isset($_POST['email']) ? $conn->real_escape_string(trim($_POST['email'])) : '';
            $wc_id = isset($_POST['wc_id']) ? (int)$_POST['wc_id'] : 0;
            $status = isset($_POST['status']) ? $conn->real_escape_string(trim($_POST['status'])) : '';
            
            if ($borrower_id <= 0) {
                throw new Exception('Borrower ID tidak valid');
            }
            
            if (empty($username) || empty($nama_borrower) || empty($nik) || $wc_id <= 0 || empty($status)) {
                throw new Exception('Field username, nama borrower, NIK, Work Center, dan status wajib diisi');
            }
            
            // Check if borrower exists
            $check_borrower = "SELECT id FROM borrower_users WHERE id = $borrower_id";
            $result_borrower = $conn->query($check_borrower);
            
            if ($result_borrower->num_rows == 0) {
                throw new Exception('Borrower tidak ditemukan');
            }
            
            // Check if username already exists (except current borrower)
            $check_username = "SELECT id FROM borrower_users WHERE username = '$username' AND id != $borrower_id";
            $result_username = $conn->query($check_username);
            
            if ($result_username->num_rows > 0) {
                throw new Exception('Username sudah digunakan oleh borrower lain');
            }
            
            // Check if NIK already exists (except current borrower)
            $check_nik = "SELECT id FROM borrower_users WHERE nik = '$nik' AND id != $borrower_id";
            $result_nik = $conn->query($check_nik);
            
            if ($result_nik->num_rows > 0) {
                throw new Exception('NIK sudah digunakan oleh borrower lain');
            }
            
            // Check if WC already assigned to another user (except current borrower)
            $check_wc = "SELECT id FROM borrower_users WHERE wc_id = $wc_id AND id != $borrower_id";
            $result_wc = $conn->query($check_wc);
            
            if ($result_wc->num_rows > 0) {
                throw new Exception('Work Center sudah dimiliki user lain');
            }
            
            // Check if WC ID exists and is active
            $check_wc_master = "SELECT id FROM wc_master WHERE id = $wc_id AND is_active = 1";
            $check_result = $conn->query($check_wc_master);
            
            if($check_result->num_rows == 0) {
                throw new Exception('Work Center tidak valid atau tidak aktif');
            }
            
            // Build update query
            $update_fields = "username = '$username', nama_borrower = '$nama_borrower', nik = '$nik', email = '$email', wc_id = $wc_id, status = '$status', updated_at = NOW()";
            
            // Add password if provided
            if (!empty($password)) {
                $hashed_password = password_hash($password, PASSWORD_DEFAULT);
                $update_fields = "password = '$hashed_password', " . $update_fields;
            }
            
            $query = "UPDATE borrower_users SET $update_fields WHERE id = $borrower_id";
            
            if(!$conn->query($query)) {
                throw new Exception($conn->error);
            }
            
            $conn->commit();
            
            // Log audit
            $audit_query = "INSERT INTO audit_logs (action_type, user_id, user_type, details, timestamp, ip_address) 
                           VALUES ('EDIT_BORROWER_USER', ?, 'it', ?, NOW(), ?)";
            $audit_stmt = $conn->prepare($audit_query);
            $user_id = $_SESSION['user_id'];
            $audit_details = "Updated borrower user ID: $borrower_id - $nama_borrower ($username - WC ID: $wc_id)";
            $ip_address = $_SERVER['REMOTE_ADDR'];
            $audit_stmt->bind_param("iss", $user_id, $audit_details, $ip_address);
            $audit_stmt->execute();
            $audit_stmt->close();
            
            echo json_encode(['success' => true, 'message' => 'Borrower berhasil diupdate']);
            break;
            
        case 'delete_borrower':
            $borrower_id = isset($_POST['borrower_id']) ? (int)$_POST['borrower_id'] : 0;
            
            if ($borrower_id <= 0) {
                throw new Exception('Borrower ID tidak valid');
            }
            
            // Check if borrower exists and get data for audit
            $check_borrower = "SELECT username, nama_borrower, wc_id FROM borrower_users WHERE id = $borrower_id";
            $result_borrower = $conn->query($check_borrower);
            
            if ($result_borrower->num_rows == 0) {
                throw new Exception('Borrower tidak ditemukan');
            }
            
            $borrower_data = $result_borrower->fetch_assoc();
            
            // Check if borrower is being used in any transactions
            $check_usage = "SELECT COUNT(*) as total FROM stock_transactions WHERE borrower_id = $borrower_id";
            $result_usage = $conn->query($check_usage);
            $usage_data = $result_usage->fetch_assoc();
            
            if($usage_data['total'] > 0) {
                throw new Exception('Borrower tidak dapat dihapus karena masih memiliki riwayat transaksi');
            }
            
            $query = "DELETE FROM borrower_users WHERE id = $borrower_id";
            
            if(!$conn->query($query)) {
                throw new Exception($conn->error);
            }
            
            $conn->commit();
            
            // Log audit
            $audit_query = "INSERT INTO audit_logs (action_type, user_id, user_type, details, timestamp, ip_address) 
                           VALUES ('DELETE_BORROWER_USER', ?, 'it', ?, NOW(), ?)";
            $audit_stmt = $conn->prepare($audit_query);
            $user_id = $_SESSION['user_id'];
            $username = $borrower_data['username'];
            $nama_borrower = $borrower_data['nama_borrower'];
            $wc_id = $borrower_data['wc_id'];
            $audit_details = "Deleted borrower user: $nama_borrower ($username - WC ID: $wc_id)";
            $ip_address = $_SERVER['REMOTE_ADDR'];
            $audit_stmt->bind_param("iss", $user_id, $audit_details, $ip_address);
            $audit_stmt->execute();
            $audit_stmt->close();
            
            echo json_encode(['success' => true, 'message' => 'Borrower berhasil dihapus']);
            break;
            
        default:
            throw new Exception('Invalid action');
            break;
    }
    
} catch(Exception $e) {
    $conn->rollback();
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
} finally {
    $conn->close();
}
?>