<?php
// Set page title
$page_title = "Dashboard";

// Include header
include '../template_it/header.php';

// Query untuk mengambil statistik
// Total Buyers
$query_buyers = "SELECT COUNT(*) as total FROM buyers";
$result_buyers = $conn->query($query_buyers);
$total_buyers = $result_buyers->fetch_assoc()['total'];

// Total Collections
$query_collections = "SELECT COUNT(*) as total FROM collections";
$result_collections = $conn->query($query_collections);
$total_collections = $result_collections->fetch_assoc()['total'];

// Total Master Colors
$query_master_colors = "SELECT COUNT(*) as total FROM master_color";
$result_master_colors = $conn->query($query_master_colors);
$total_master_colors = $result_master_colors->fetch_assoc()['total'];

// Total Master Color Panels
$query_master_panels = "SELECT COUNT(*) as total FROM master_color_panel";
$result_master_panels = $conn->query($query_master_panels);
$total_master_panels = $result_master_panels->fetch_assoc()['total'];

// Total Master Color Panels yang tidak boleh dipinjam
$query_master_only = "SELECT COUNT(*) as total FROM master_color_panel WHERE is_master_only = 1";
$result_master_only = $conn->query($query_master_only);
$total_master_only = $result_master_only->fetch_assoc()['total'];

// Total Stock Items
$query_stock_items = "SELECT COUNT(*) as total FROM color_stock_items";
$result_stock_items = $conn->query($query_stock_items);
$total_stock_items = $result_stock_items->fetch_assoc()['total'];

// Total Stock Items Available
$query_stock_available = "SELECT COUNT(*) as total FROM color_stock_items WHERE status = 'available'";
$result_stock_available = $conn->query($query_stock_available);
$total_stock_available = $result_stock_available->fetch_assoc()['total'];

// Total Stock Items Borrowed
$query_stock_borrowed = "SELECT COUNT(*) as total FROM color_stock_items WHERE status = 'borrowed'";
$result_stock_borrowed = $conn->query($query_stock_borrowed);
$total_stock_borrowed = $result_stock_borrowed->fetch_assoc()['total'];

// Total Borrowers
$query_borrowers = "SELECT COUNT(*) as total FROM borrower_users WHERE status = 'active'";
$result_borrowers = $conn->query($query_borrowers);
$total_borrowers = $result_borrowers->fetch_assoc()['total'];
?>

<!-- Dashboard Content -->
<div class="container mx-auto">
    <!-- Welcome Section -->
    <div class="bg-white rounded-lg shadow-md p-6 mb-6">
        <div class="flex items-center justify-between">
            <div>
                <h2 class="text-2xl font-bold text-gray-800">Selamat Datang, <?php echo htmlspecialchars($_SESSION['username']); ?>!</h2>
                <p class="text-gray-600 mt-1">Panel IT - Color Access System</p>
            </div>
            <div class="hidden md:block">
                <div class="text-right">
                    <p class="text-sm text-gray-500">Tanggal</p>
                    <p class="text-lg font-semibold text-gray-800"><?php echo date('d F Y'); ?></p>
                </div>
            </div>
        </div>
    </div>

    <!-- Statistics Cards -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-6">
        <!-- Card 1: Total Buyers -->
        <div class="bg-white rounded-lg shadow-md p-6 hover:shadow-lg transition-shadow duration-300">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-gray-500 text-sm font-medium">Total Buyers</p>
                    <h3 class="text-3xl font-bold text-gray-800 mt-2"><?php echo $total_buyers; ?></h3>
                </div>
                <div class="bg-blue-100 rounded-full p-4">
                    <i class="fas fa-users text-blue-600 text-2xl"></i>
                </div>
            </div>
        </div>

        <!-- Card 2: Total Collections -->
        <div class="bg-white rounded-lg shadow-md p-6 hover:shadow-lg transition-shadow duration-300">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-gray-500 text-sm font-medium">Total Collections</p>
                    <h3 class="text-3xl font-bold text-gray-800 mt-2"><?php echo $total_collections; ?></h3>
                </div>
                <div class="bg-green-100 rounded-full p-4">
                    <i class="fas fa-layer-group text-green-600 text-2xl"></i>
                </div>
            </div>
        </div>

        <!-- Card 3: Total Master Colors -->
        <div class="bg-white rounded-lg shadow-md p-6 hover:shadow-lg transition-shadow duration-300">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-gray-500 text-sm font-medium">Master Colors</p>
                    <h3 class="text-3xl font-bold text-gray-800 mt-2"><?php echo $total_master_colors; ?></h3>
                </div>
                <div class="bg-purple-100 rounded-full p-4">
                    <i class="fas fa-palette text-purple-600 text-2xl"></i>
                </div>
            </div>
        </div>

        <!-- Card 4: Total Master Panels -->
        <div class="bg-white rounded-lg shadow-md p-6 hover:shadow-lg transition-shadow duration-300">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-gray-500 text-sm font-medium">Master Panels</p>
                    <h3 class="text-3xl font-bold text-gray-800 mt-2"><?php echo $total_master_panels; ?></h3>
                </div>
                <div class="bg-yellow-100 rounded-full p-4">
                    <i class="fas fa-th-large text-yellow-600 text-2xl"></i>
                </div>
            </div>
        </div>
    </div>

    <!-- Stock Information Cards -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-6">
        <!-- Card 5: Panel Master Only -->
        <div class="bg-white rounded-lg shadow-md p-6 hover:shadow-lg transition-shadow duration-300">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-gray-500 text-sm font-medium">Panel Master Only</p>
                    <h3 class="text-3xl font-bold text-gray-800 mt-2"><?php echo $total_master_only; ?></h3>
                    <p class="text-xs text-red-500 mt-1">Tidak boleh dipinjam</p>
                </div>
                <div class="bg-red-100 rounded-full p-4">
                    <i class="fas fa-lock text-red-600 text-2xl"></i>
                </div>
            </div>
        </div>

        <!-- Card 6: Total Stock Items -->
        <div class="bg-white rounded-lg shadow-md p-6 hover:shadow-lg transition-shadow duration-300">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-gray-500 text-sm font-medium">Total Stock Items</p>
                    <h3 class="text-3xl font-bold text-gray-800 mt-2"><?php echo $total_stock_items; ?></h3>
                </div>
                <div class="bg-indigo-100 rounded-full p-4">
                    <i class="fas fa-boxes text-indigo-600 text-2xl"></i>
                </div>
            </div>
        </div>

        <!-- Card 7: Stock Available -->
        <div class="bg-white rounded-lg shadow-md p-6 hover:shadow-lg transition-shadow duration-300">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-gray-500 text-sm font-medium">Stock Available</p>
                    <h3 class="text-3xl font-bold text-gray-800 mt-2"><?php echo $total_stock_available; ?></h3>
                    <p class="text-xs text-green-500 mt-1">Siap dipinjam</p>
                </div>
                <div class="bg-teal-100 rounded-full p-4">
                    <i class="fas fa-check-circle text-teal-600 text-2xl"></i>
                </div>
            </div>
        </div>

        <!-- Card 8: Stock Borrowed -->
        <div class="bg-white rounded-lg shadow-md p-6 hover:shadow-lg transition-shadow duration-300">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-gray-500 text-sm font-medium">Stock Borrowed</p>
                    <h3 class="text-3xl font-bold text-gray-800 mt-2"><?php echo $total_stock_borrowed; ?></h3>
                    <p class="text-xs text-orange-500 mt-1">Sedang dipinjam</p>
                </div>
                <div class="bg-orange-100 rounded-full p-4">
                    <i class="fas fa-hand-holding text-orange-600 text-2xl"></i>
                </div>
            </div>
        </div>
    </div>

    <!-- Quick Actions -->
    <div class="bg-white rounded-lg shadow-md p-6">
        <h3 class="text-xl font-bold text-gray-800 mb-4">Quick Actions</h3>
        <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
            <a href="form_data.php" class="flex items-center p-4 bg-blue-50 rounded-lg hover:bg-blue-100 transition-colors duration-200">
                <div class="bg-blue-500 rounded-full p-3 mr-4">
                    <i class="fas fa-plus text-white text-xl"></i>
                </div>
                <div>
                    <p class="font-semibold text-gray-800">Input Data Baru</p>
                    <p class="text-sm text-gray-600">Tambah warna baru</p>
                </div>
            </a>

            <a href="stock_color_panel.php" class="flex items-center p-4 bg-green-50 rounded-lg hover:bg-green-100 transition-colors duration-200">
                <div class="bg-green-500 rounded-full p-3 mr-4">
                    <i class="fas fa-box text-white text-xl"></i>
                </div>
                <div>
                    <p class="font-semibold text-gray-800">Kelola Stock</p>
                    <p class="text-sm text-gray-600">Manajemen stock items</p>
                </div>
            </a>

            <a href="buyer_collection.php" class="flex items-center p-4 bg-purple-50 rounded-lg hover:bg-purple-100 transition-colors duration-200">
                <div class="bg-purple-500 rounded-full p-3 mr-4">
                    <i class="fas fa-users text-white text-xl"></i>
                </div>
                <div>
                    <p class="font-semibold text-gray-800">Buyer & Collection</p>
                    <p class="text-sm text-gray-600">Kelola buyer</p>
                </div>
            </a>
        </div>
    </div>
</div>

<?php
// Include footer
include '../template_it/footer.php';
?>