<?php
// get_stock_details_all.php
require_once '../config/connection.php';

header('Content-Type: application/json');

$master_color_id = isset($_GET['master_color_id']) ? (int)$_GET['master_color_id'] : 0;

if ($master_color_id <= 0) {
    echo json_encode(['success' => false, 'message' => 'Invalid Master Color ID']);
    exit;
}

try {
    $query = "
        SELECT 
            csi.id,
            csi.code_color,
            csi.qr_code,
            csi.code_barang_lemari5,
            csi.lemari_number,
            csi.qty,
            csi.lokasi_penyimpanan,
            csi.manufacturing_date,
            csi.expired_date,
            mc.code_color as master_code,
            mc.color_name as master_name,
            mc.lemari as mc_lemari,
            mc.lemari_number as mc_lemari_number,
            b.nama_buyer as buyer_name,
            b.kode_buyer,
            c.nama_collection,
            cc.component_name
        FROM color_stock_items csi
        LEFT JOIN master_color mc ON csi.master_color_id = mc.id
        LEFT JOIN buyers b ON mc.buyer_id = b.id
        LEFT JOIN collections c ON mc.collection_id = c.id
        LEFT JOIN color_components cc ON csi.component_id = cc.id
        WHERE csi.master_color_id = $master_color_id
        ORDER BY csi.code_color ASC
    ";
    
    $result = $conn->query($query);
    
    if ($result && $result->num_rows > 0) {
        $details = [];
        
        while ($row = $result->fetch_assoc()) {
            $mfg_date = date('d-m-Y', strtotime($row['manufacturing_date']));
            $exp_date = date('d-m-Y', strtotime($row['expired_date']));
            
            if (!empty($row['lemari_number']) && !empty($row['qty'])) {
                $lemari_display = $row['lemari_number'] . ' - ' . str_pad($row['qty'], 3, '0', STR_PAD_LEFT);
            } else if (!empty($row['code_barang_lemari5'])) {
                $lemari_display = $row['code_barang_lemari5'];
            } else if (!empty($row['mc_lemari']) && !empty($row['mc_lemari_number'])) {
                $lemari_display = $row['mc_lemari'] . ' - ' . str_pad($row['mc_lemari_number'], 3, '0', STR_PAD_LEFT);
            } else {
                $lemari_display = '-';
            }
            
            $details[] = [
                'code_color' => $row['code_color'],
                'master_code' => $row['master_code'],
                'master_name' => $row['master_name'],
                'buyer_name' => $row['buyer_name'],
                'kode_buyer' => $row['kode_buyer'],
                'component_name' => $row['component_name'],
                'code_barang' => $row['code_color'],
                'lokasi_penyimpanan' => $row['lokasi_penyimpanan'],
                'lemari' => $lemari_display,
                'manufacturing_date' => $mfg_date,
                'expired_date' => $exp_date,
                'qr_image' => $row['qr_code']
            ];
        }
        
        echo json_encode([
            'success' => true,
            'details' => $details,
            'total' => count($details)
        ]);
    } else {
        echo json_encode(['success' => false, 'message' => 'No stock items found']);
    }
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Error: ' . $e->getMessage()]);
}

$conn->close();
?>