<?php
// Set page title
$page_title = "Data QR Master Panel Management";

// Include header
include '../template_it/header.php';

// Get filters from URL
$buyer_filter = isset($_GET['buyer_id']) ? (int)$_GET['buyer_id'] : 0;
$search = isset($_GET['search']) ? $conn->real_escape_string($_GET['search']) : '';

// Query untuk mengambil data buyers untuk filter dropdown
$query_buyers = "SELECT id, nama_buyer, kode_buyer FROM buyers ORDER BY nama_buyer ASC";
$result_buyers = $conn->query($query_buyers);
?>

<!-- Data QR Master Panel Content -->
<div class="container mx-auto">
    <!-- Page Header -->
    <div class="bg-white rounded-lg shadow-md p-6 mb-6">
        <div class="flex items-center justify-between">
            <div>
                <h2 class="text-2xl font-bold text-gray-800">
                    <i class="fas fa-qrcode text-purple-600 mr-2"></i>
                    Data QR Master Panel Management
                </h2>
                <p class="text-gray-600 mt-1">Generate QR Code untuk Master Color Panel</p>
            </div>
        </div>
    </div>

    <!-- Filter Section -->
    <div class="bg-white rounded-lg shadow-md p-6 mb-6">
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
            <!-- Filter Buyer -->
            <div>
                <label class="block text-gray-700 font-semibold mb-2">
                    <i class="fas fa-building mr-1"></i> Filter Buyer:
                </label>
                <select id="buyerFilter" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-500" onchange="applyFilter()">
                    <option value="0">-- Semua Buyer --</option>
                    <?php 
                    $result_buyers->data_seek(0);
                    while($buyer = $result_buyers->fetch_assoc()): 
                    ?>
                        <option value="<?php echo $buyer['id']; ?>" <?php echo ($buyer_filter == $buyer['id']) ? 'selected' : ''; ?>>
                            <?php echo htmlspecialchars($buyer['nama_buyer']) . ' (' . htmlspecialchars($buyer['kode_buyer']) . ')'; ?>
                        </option>
                    <?php endwhile; ?>
                </select>
            </div>

            <!-- Search -->
            <div>
                <label class="block text-gray-700 font-semibold mb-2">
                    <i class="fas fa-search mr-1"></i> Search:
                </label>
                <input 
                    type="text" 
                    id="searchInput" 
                    value="<?php echo htmlspecialchars($search); ?>"
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-500"
                    placeholder="Cari panel code atau master code..."
                    onkeypress="if(event.key === 'Enter') applyFilter()">
            </div>
        </div>

        <div class="flex gap-2 mt-4">
            <button onclick="applyFilter()" class="bg-purple-600 hover:bg-purple-700 text-white px-6 py-2 rounded-lg transition-colors">
                <i class="fas fa-filter mr-2"></i> Filter
            </button>
            <?php if($buyer_filter > 0 || !empty($search)): ?>
                <button onclick="resetFilter()" class="bg-red-500 hover:bg-red-600 text-white px-6 py-2 rounded-lg transition-colors">
                    <i class="fas fa-redo mr-2"></i> Reset
                </button>
            <?php endif; ?>
        </div>
    </div>

    <!-- Master Color Panel List -->
    <div class="bg-white rounded-lg shadow-md p-6">
        <h3 class="text-xl font-bold text-gray-800 mb-4 flex items-center">
            <i class="fas fa-clipboard-list text-purple-600 mr-2"></i>
            Master Color Panel Data
        </h3>

        <?php
        // Query untuk mengambil master color panel data
        $query_panel = "
            SELECT 
                mcp.id as panel_id,
                mcp.panel_code,
                mcp.rack_number,
                mcp.qr_code as panel_qr_code,
                mcp.manufacturing_date as panel_manufacturing_date,
                mcp.expired_date as panel_expired_date,
                mcp.created_at as panel_created_at,
                mc.code_color as master_code,
                mc.color_name,
                mc.lemari,
                mc.lemari_number,
                mc.manufacturing_date as master_manufacturing_date,
                mc.expired_date as master_expired_date,
                b.nama_buyer,
                b.kode_buyer,
                c.nama_collection,
                COUNT(csi.id) as total_stock_items,
                COUNT(CASE WHEN csi.status = 'available' THEN 1 END) as available_items,
                COUNT(CASE WHEN csi.status = 'borrowed' THEN 1 END) as borrowed_items,
                COUNT(CASE WHEN csi.status = 'expired' THEN 1 END) as expired_items
            FROM master_color_panel mcp
            LEFT JOIN master_color mc ON mcp.master_color_id = mc.id
            LEFT JOIN buyers b ON mc.buyer_id = b.id
            LEFT JOIN collections c ON mc.collection_id = c.id
            LEFT JOIN color_stock_items csi ON mc.id = csi.master_color_id
            WHERE 1=1
        ";
        
        if ($buyer_filter > 0) {
            $query_panel .= " AND mc.buyer_id = $buyer_filter";
        }
        
        if (!empty($search)) {
            $query_panel .= " AND (mcp.panel_code LIKE '%$search%' OR mc.code_color LIKE '%$search%' OR mc.color_name LIKE '%$search%')";
        }
        
        $query_panel .= " GROUP BY mcp.id ORDER BY mcp.created_at DESC";
        
        $result_panel = $conn->query($query_panel);
        
        if ($result_panel && $result_panel->num_rows > 0):
        ?>
            <div class="space-y-4">
                <?php while($panel = $result_panel->fetch_assoc()): ?>
                    <div class="border border-gray-200 rounded-lg overflow-hidden hover:shadow-lg transition-shadow">
                        <!-- Panel Header -->
                        <div class="bg-gradient-to-r from-purple-50 to-indigo-50 p-4">
                            <div class="flex items-center justify-between">
                                <div class="flex items-center gap-4">
                                    <div class="bg-purple-600 text-white px-4 py-2 rounded-lg font-bold text-lg">
                                        <?php echo htmlspecialchars($panel['panel_code']); ?>
                                    </div>
                                    <div>
                                        <h4 class="text-lg font-bold text-gray-800">
                                            Panel: <?php echo htmlspecialchars($panel['panel_code']); ?>
                                        </h4>
                                        <p class="text-sm text-gray-600">
                                            <span class="font-semibold">Master:</span> <?php echo htmlspecialchars($panel['master_code']); ?> - 
                                            <?php echo htmlspecialchars($panel['color_name']); ?>
                                        </p>
                                        <p class="text-sm text-gray-600">
                                            <span class="font-semibold"><?php echo htmlspecialchars($panel['nama_buyer']); ?></span>
                                            (<?php echo htmlspecialchars($panel['kode_buyer']); ?>) - 
                                            <?php echo htmlspecialchars($panel['nama_collection']); ?>
                                        </p>
                                        <div class="flex items-center gap-4 text-xs text-gray-500 mt-1">
                                            <span>
                                                <i class="fas fa-layer-group mr-1"></i>
                                                Rack: <?php echo str_pad($panel['rack_number'], 2, '0', STR_PAD_LEFT); ?>
                                            </span>
                                            <span>
                                                <i class="fas fa-archive mr-1"></i>
                                                Lemari <?php echo htmlspecialchars($panel['lemari']); ?> - 
                                                No. <?php echo str_pad($panel['lemari_number'], 3, '0', STR_PAD_LEFT); ?>
                                            </span>
                                            <?php
                                            // Use panel dates if available, otherwise use master dates
                                            $mfg_date = !empty($panel['panel_manufacturing_date']) ? $panel['panel_manufacturing_date'] : $panel['master_manufacturing_date'];
                                            $exp_date = !empty($panel['panel_expired_date']) ? $panel['panel_expired_date'] : $panel['master_expired_date'];
                                            ?>
                                            <?php if(!empty($mfg_date)): ?>
                                                <span>
                                                    <i class="fas fa-calendar mr-1"></i>
                                                    Panel Dibuat: <?php echo date('d/m/Y', strtotime($mfg_date)); ?>
                                                </span>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                                <div class="flex items-center gap-3 flex-col lg:flex-row">
                                    <!-- Stock Summary -->
                                    <div class="grid grid-cols-2 gap-2 text-xs">
                                        <span class="bg-blue-100 text-blue-800 px-2 py-1 rounded-full font-semibold">
                                            <i class="fas fa-boxes mr-1"></i>
                                            Total: <?php echo $panel['total_stock_items']; ?>
                                        </span>
                                        <span class="bg-green-100 text-green-800 px-2 py-1 rounded-full font-semibold">
                                            <i class="fas fa-check-circle mr-1"></i>
                                            Tersedia: <?php echo $panel['available_items']; ?>
                                        </span>
                                        <span class="bg-yellow-100 text-yellow-800 px-2 py-1 rounded-full font-semibold">
                                            <i class="fas fa-hand-holding mr-1"></i>
                                            Dipinjam: <?php echo $panel['borrowed_items']; ?>
                                        </span>
                                        <span class="bg-red-100 text-red-800 px-2 py-1 rounded-full font-semibold">
                                            <i class="fas fa-exclamation-triangle mr-1"></i>
                                            Expired: <?php echo $panel['expired_items']; ?>
                                        </span>
                                    </div>
                                    
                                    <!-- Action Buttons -->
                                    <div class="flex gap-2">
                                        <?php if(!empty($panel['panel_qr_code'])): ?>
                                            <button 
                                                onclick="viewPanelQR('<?php echo htmlspecialchars($panel['panel_code']); ?>', '<?php echo htmlspecialchars($panel['master_code']); ?>')"
                                                class="bg-blue-600 hover:bg-blue-700 text-white px-3 py-2 rounded-lg transition-colors font-semibold text-sm">
                                                <i class="fas fa-eye mr-1"></i>
                                                View QR
                                            </button>
                                        <?php endif; ?>
                                        <button 
                                            onclick="generatePanelQR(<?php echo $panel['panel_id']; ?>, '<?php echo htmlspecialchars($panel['panel_code']); ?>', '<?php echo htmlspecialchars($panel['master_code']); ?>')"
                                            class="bg-purple-600 hover:bg-purple-700 text-white px-3 py-2 rounded-lg transition-colors font-semibold text-sm">
                                            <i class="fas fa-qrcode mr-1"></i>
                                            Generate QR Panel
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endwhile; ?>
            </div>
        <?php else: ?>
            <div class="text-center py-12">
                <i class="fas fa-inbox text-gray-300 text-6xl mb-4"></i>
                <p class="text-gray-500 text-lg">Tidak ada data master color panel</p>
            </div>
        <?php endif; ?>
    </div>
</div>

<!-- QR Code Modal -->
<div id="qrModal" class="fixed inset-0 bg-black bg-opacity-50 hidden z-50 flex items-center justify-center p-4">
    <div class="bg-white rounded-lg max-w-4xl w-full max-h-[90vh] overflow-y-auto">
        <div class="flex justify-between items-center p-6 border-b">
            <h3 class="text-xl font-bold" id="modalTitle">QR Code Master Panel</h3>
            <button onclick="closeModal()" class="text-gray-500 hover:text-gray-700 text-2xl">&times;</button>
        </div>
        <div id="modalContent" class="p-6">
            <!-- QR content will be loaded here -->
        </div>
        <div class="flex justify-end gap-3 p-6 border-t">
            <button onclick="printPanelQR()" class="bg-purple-600 hover:bg-purple-700 text-white px-6 py-2 rounded-lg transition-colors">
                <i class="fas fa-print mr-2"></i> Print QR
            </button>
            <button onclick="closeModal()" class="bg-gray-500 hover:bg-gray-600 text-white px-6 py-2 rounded-lg transition-colors">
                Close
            </button>
        </div>
    </div>
</div>

<script>
let currentPanelData = {};

function applyFilter() {
    const buyerId = document.getElementById('buyerFilter').value;
    const search = document.getElementById('searchInput').value;
    
    let url = 'master_turunan.php?';
    if (buyerId && buyerId !== '0') {
        url += 'buyer_id=' + buyerId + '&';
    }
    if (search) {
        url += 'search=' + encodeURIComponent(search) + '&';
    }
    
    window.location.href = url;
}

function resetFilter() {
    window.location.href = 'master_turunan.php';
}

function generatePanelQR(panelId, panelCode, masterCode) {
    currentPanelData = {
        id: panelId,
        panel_code: panelCode,
        master_code: masterCode,
        location: 'Color Room'
    };
    
    document.getElementById('modalTitle').textContent = `Generate QR Panel - ${panelCode}`;
    document.getElementById('modalContent').innerHTML = `
        <div class="text-center">
            <div class="animate-spin rounded-full h-12 w-12 border-b-2 border-purple-600 mx-auto mb-4"></div>
            <p>Generating QR Code...</p>
        </div>
    `;
    
    document.getElementById('qrModal').classList.remove('hidden');
    
    fetch('generate_qr_panel.php?panel_id=' + panelId)
        .then(response => response.json())
        .then(data => {
            if(data.success) {
                currentPanelData.buyer = data.buyer_name || 'Master';
                currentPanelData.collection = data.collection_name || '';
                currentPanelData.manufacturing_date = data.manufacturing_date || '-';
                currentPanelData.expired_date = data.expired_date || '-';
                currentPanelData.rack_number = data.rack_number || '';
                currentPanelData.color_name = data.color_name || '';
                
                document.getElementById('modalContent').innerHTML = `
                    <div class="text-center">
                        <div class="bg-gradient-to-r from-purple-50 to-indigo-50 p-6 rounded-lg mb-6">
                            <h4 class="text-xl font-bold text-gray-800 mb-2">${panelCode}</h4>
                            <p class="text-gray-600">Master: ${masterCode}</p>
                            <p class="text-sm text-gray-500">${data.buyer_name}</p>
                            <div class="grid grid-cols-2 gap-4 mt-3 text-xs">
                                <p><strong>Tgl Pembuatan:</strong> ${data.manufacturing_date}</p>
                                <p><strong>Tgl Kedaluwarsa:</strong> ${data.expired_date}</p>
                            </div>
                        </div>
                        
                        <div class="bg-white border-4 border-purple-600 rounded-lg p-8 inline-block">
                            <img src="${data.qr_image}" alt="QR Code Panel" class="w-64 h-64 mx-auto">
                        </div>
                        
                        <div class="mt-6 text-sm text-gray-600">
                            <p><strong>Panel Code:</strong> ${panelCode}</p>
                            <p><strong>Master Code:</strong> ${masterCode}</p>
                            <p><strong>Buyer:</strong> ${data.buyer_name}</p>
                            <p><strong>Rack:</strong> ${data.rack_number}</p>
                            <p class="text-xs text-gray-500 mt-2">Scan QR code ini untuk melihat detail master color panel</p>
                        </div>
                    </div>
                `;
            } else {
                document.getElementById('modalContent').innerHTML = `
                    <div class="text-center text-red-600">
                        <i class="fas fa-exclamation-triangle text-4xl mb-4"></i>
                        <p>Error: ${data.message}</p>
                    </div>
                `;
            }
        })
        .catch(error => {
            document.getElementById('modalContent').innerHTML = `
                <div class="text-center text-red-600">
                    <i class="fas fa-exclamation-triangle text-4xl mb-4"></i>
                    <p>Error: ${error}</p>
                </div>
            `;
        });
}

function viewPanelQR(panelCode, masterCode) {
    currentPanelData = {
        panel_code: panelCode,
        master_code: masterCode
    };
    
    document.getElementById('modalTitle').textContent = `QR Panel - ${panelCode}`;
    document.getElementById('modalContent').innerHTML = `
        <div class="text-center">
            <div class="animate-spin rounded-full h-12 w-12 border-b-2 border-purple-600 mx-auto mb-4"></div>
            <p>Loading QR Code...</p>
        </div>
    `;
    
    document.getElementById('qrModal').classList.remove('hidden');
    
    fetch('get_panel_qr.php?panel_code=' + encodeURIComponent(panelCode))
        .then(response => response.json())
        .then(data => {
            if(data.success && data.qr_image) {
                currentPanelData.buyer = data.buyer_name || 'Brunswick';
                currentPanelData.collection = data.collection_name || '';
                currentPanelData.manufacturing_date = data.manufacturing_date || '-';
                currentPanelData.expired_date = data.expired_date || '-';
                currentPanelData.rack_number = data.rack_number || '';
                currentPanelData.color_name = data.color_name || '';
                
                document.getElementById('modalContent').innerHTML = `
                    <div class="text-center">
                        <div class="bg-gradient-to-r from-purple-50 to-indigo-50 p-6 rounded-lg mb-6">
                            <h4 class="text-xl font-bold text-gray-800 mb-2">${panelCode}</h4>
                            <p class="text-gray-600">Master: ${data.master_code}</p>
                            <div class="grid grid-cols-2 gap-4 mt-3 text-xs">
                                <p><strong>Tgl Pembuatan:</strong> ${data.manufacturing_date}</p>
                                <p><strong>Tgl Kedaluwarsa:</strong> ${data.expired_date}</p>
                            </div>
                        </div>
                        
                        <div class="bg-white border-4 border-purple-600 rounded-lg p-8 inline-block">
                            <img src="${data.qr_image}" alt="QR Code Panel" class="w-64 h-64 mx-auto">
                        </div>
                        
                        <div class="mt-6 text-sm text-gray-600">
                            <p><strong>Panel Code:</strong> ${panelCode}</p>
                            <p><strong>Master Code:</strong> ${data.master_code}</p>
                            <p><strong>Rack:</strong> ${data.rack_number}</p>
                            <p class="text-xs text-gray-500 mt-2">Scan QR code ini untuk melihat detail master color panel</p>
                        </div>
                    </div>
                `;
            } else {
                document.getElementById('modalContent').innerHTML = `
                    <div class="text-center text-red-600">
                        <i class="fas fa-exclamation-triangle text-4xl mb-4"></i>
                        <p>QR Code tidak ditemukan atau belum di-generate</p>
                    </div>
                `;
            }
        });
}

function closeModal() {
    document.getElementById('qrModal').classList.add('hidden');
}

function printPanelQR() {
    const qrImage = document.querySelector('#modalContent img');
    if (!qrImage) {
        alert('QR Code tidak tersedia untuk dicetak');
        return;
    }
    
    let printContent = `
        <!DOCTYPE html>
        <html>
        <head>
            <title>Print QR Panel - ${currentPanelData.panel_code}</title>
            <style>
                @page {
                    size: A4;
                    margin: 15mm;
                }
                body {
                    font-family: Arial, sans-serif;
                    margin: 0;
                    padding: 20px;
                }
                .container {
                    max-width: 400px;
                    margin: 0 auto;
                    padding: 20px;
                    background: white;
                    border: 2px solid #000;
                }
                .header {
                    text-align: center;
                    margin-bottom: 15px;
                }
                .panel-btn {
                    background: #7C3AED;
                    color: white;
                    padding: 6px 12px;
                    border: 2px solid #000;
                    border-radius: 15px;
                    font-size: 10px;
                    margin-bottom: 10px;
                    display: inline-block;
                    font-weight: bold;
                }
                .title {
                    font-size: 18px;
                    font-weight: bold;
                    color: #000;
                    margin-bottom: 5px;
                }
                .subtitle {
                    font-size: 12px;
                    color: #666;
                    margin-bottom: 20px;
                }
                .qr-container {
                    text-align: center;
                    margin: 20px 0;
                    padding: 15px;
                    border: 2px solid #ddd;
                    background: #f9f9f9;
                }
                .qr-image {
                    width: 200px;
                    height: 200px;
                }
                .info-grid {
                    display: grid;
                    grid-template-columns: 1fr 1fr;
                    gap: 15px 20px;
                    font-size: 11px;
                    margin: 20px 0;
                }
                .info-item {
                    text-align: center;
                }
                .info-label {
                    font-weight: bold;
                    color: #000;
                    margin-bottom: 3px;
                }
                .info-value {
                    color: #000;
                    word-break: break-word;
                }
                .signatures {
                    margin-top: 30px;
                    padding-top: 20px;
                    border-top: 1px solid #ddd;
                }
                .signature-row {
                    display: grid;
                    grid-template-columns: 1fr 1fr 1fr;
                    gap: 20px;
                    margin-bottom: 50px;
                    text-align: center;
                    font-size: 10px;
                }
                .signature-item {
                    min-height: 60px;
                    display: flex;
                    flex-direction: column;
                    justify-content: space-between;
                }
                .signature-title {
                    font-weight: bold;
                    margin-bottom: 40px;
                }
                .signature-line {
                    border-bottom: 1px solid #000;
                    margin-bottom: 5px;
                    height: 1px;
                }
                .signature-name {
                    font-size: 9px;
                    color: #666;
                }
                .signature-row-2 {
                    display: grid;
                    grid-template-columns: 1fr 1fr;
                    gap: 40px;
                    text-align: center;
                    font-size: 10px;
                }
            </style>
        </head>
        <body>
            <div class="container">
                <div class="header">
                    <div class="panel-btn">PANEL</div>
                    <div class="title">${currentPanelData.panel_code} - ${currentPanelData.buyer || 'Brunswick'}</div>
                    <div class="subtitle">
                        📋 Master Panel: ${currentPanelData.panel_code}<br>
                        🎨 Master: ${currentPanelData.master_code || ''}
                    </div>
                </div>
                
                <div class="qr-container">
                    <img src="${qrImage.src}" alt="QR Code Panel" class="qr-image">
                </div>
                
                <div class="info-grid">
                    <div class="info-item">
                        <div class="info-label">Panel Code:</div>
                        <div class="info-value">${currentPanelData.panel_code}</div>
                    </div>
                    <div class="info-item">
                        <div class="info-label">Master Code:</div>
                        <div class="info-value">${currentPanelData.master_code || ''}</div>
                    </div>
                    <div class="info-item">
                        <div class="info-label">Buyer:</div>
                        <div class="info-value">${currentPanelData.buyer || 'Brunswick'}</div>
                    </div>
                    <div class="info-item">
                        <div class="info-label">Lokasi:</div>
                        <div class="info-value">Color Room</div>
                    </div>
                    <div class="info-item">
                        <div class="info-label">Tipe:</div>
                        <div class="info-value">Master Panel</div>
                    </div>
                    <div class="info-item">
                        <div class="info-label">Rack:</div>
                        <div class="info-value">${currentPanelData.rack_number || '1'}</div>
                    </div>
                    <div class="info-item">
                        <div class="info-label">Tgl Pembuatan:</div>
                        <div class="info-value">${currentPanelData.manufacturing_date || new Date().toLocaleDateString('id-ID')}</div>
                    </div>
                    <div class="info-item">
                        <div class="info-label">Tgl Kedaluwarsa:</div>
                        <div class="info-value">${currentPanelData.expired_date || '-'}</div>
                    </div>
                    <div class="info-item">
                        <div class="info-label">Status:</div>
                        <div class="info-value">Active</div>
                    </div>
                </div>
                
                <div class="signatures">
                    <div class="signature-row">
                        <div class="signature-item">
                            <div class="signature-title">K A Unit</div>
                            <div>
                                <div class="signature-line"></div>
                                <div class="signature-name">Sugiyanto</div>
                            </div>
                        </div>
                        <div class="signature-item">
                            <div class="signature-title">Color Room</div>
                            <div>
                                <div class="signature-line"></div>
                                <div class="signature-name">Radhitya</div>
                            </div>
                        </div>
                        <div class="signature-item">
                            <div class="signature-title">Akzonobel</div>
                            <div>
                                <div class="signature-line"></div>
                                <div class="signature-name">Fatchur Roji</div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="signature-row-2">
                        <div class="signature-item">
                            <div class="signature-title">Approved by</div>
                            <div>
                                <div class="signature-line"></div>
                                <div class="signature-name">-----</div>
                            </div>
                        </div>
                        <div class="signature-item">
                            <div class="signature-title">Approved by QC</div>
                            <div>
                                <div class="signature-line"></div>
                                <div class="signature-name">-----</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </body>
        </html>
    `;
    
    const printWindow = window.open('', '_blank');
    printWindow.document.write(printContent);
    printWindow.document.close();
    printWindow.focus();
    
    setTimeout(() => {
        printWindow.print();
        printWindow.close();
    }, 250);
}
</script>

<?php
include '../template_it/footer.php';
?>