<!-- Modal untuk On Going Transactions -->
<div id="ongoingModal" class="modal fixed inset-0 modal-overlay z-50 flex items-center justify-center">
    <div class="bg-white rounded-lg shadow-xl w-11/12 md:w-4/5 lg:w-3/4 xl:w-2/3 modal-content">
        <div class="p-6">
            <div class="flex justify-between items-center mb-4">
                <div class="flex items-center space-x-3">
                    <div class="bg-blue-100 p-2 rounded-full">
                        <i class="fas fa-clock text-blue-500"></i>
                    </div>
                    <div>
                        <h3 class="text-xl font-semibold text-gray-800">Transaksi On Going</h3>
                        <p class="text-sm text-gray-600">Daftar transaksi peminjaman yang masih aktif</p>
                    </div>
                </div>
                <button type="button" class="text-gray-500 hover:text-gray-700 text-2xl" onclick="closeModal('ongoingModal')">
                    <i class="fas fa-times"></i>
                </button>
            </div>
            
            <div class="modal-body">
                <!-- Content will be loaded via AJAX -->
            </div>
        </div>
    </div>
</div>

<!-- Modal untuk Dipinjam Items -->
<div id="dipinjamModal" class="modal fixed inset-0 modal-overlay z-50 flex items-center justify-center">
    <div class="bg-white rounded-lg shadow-xl w-11/12 md:w-4/5 lg:w-3/4 xl:w-2/3 modal-content">
        <div class="p-6">
            <div class="flex justify-between items-center mb-4">
                <div class="flex items-center space-x-3">
                    <div class="bg-green-100 p-2 rounded-full">
                        <i class="fas fa-hand-holding text-green-500"></i>
                    </div>
                    <div>
                        <h3 class="text-xl font-semibold text-gray-800">Code Barang Dipinjam</h3>
                        <p class="text-sm text-gray-600">Daftar code barang yang sedang dipinjam</p>
                    </div>
                </div>
                <button type="button" class="text-gray-500 hover:text-gray-700 text-2xl" onclick="closeModal('dipinjamModal')">
                    <i class="fas fa-times"></i>
                </button>
            </div>
            
            <div class="modal-body">
                <!-- Content will be loaded via AJAX -->
            </div>
        </div>
    </div>
</div>

<!-- Modal untuk Overdue Transactions -->
<div id="overdueModal" class="modal fixed inset-0 modal-overlay z-50 flex items-center justify-center">
    <div class="bg-white rounded-lg shadow-xl w-11/12 md:w-4/5 lg:w-3/4 xl:w-2/3 modal-content">
        <div class="p-6">
            <div class="flex justify-between items-center mb-4">
                <div class="flex items-center space-x-3">
                    <div class="bg-red-100 p-2 rounded-full">
                        <i class="fas fa-exclamation-triangle text-red-500"></i>
                    </div>
                    <div>
                        <h3 class="text-xl font-semibold text-gray-800">Transaksi Overdue</h3>
                        <p class="text-sm text-gray-600">Daftar transaksi peminjaman yang terlambat (>15 menit)</p>
                    </div>
                </div>
                <button type="button" class="text-gray-500 hover:text-gray-700 text-2xl" onclick="closeModal('overdueModal')">
                    <i class="fas fa-times"></i>
                </button>
            </div>
            
            <div class="modal-body">
                <!-- Content will be loaded via AJAX -->
            </div>
        </div>
    </div>
</div>

<!-- Modal untuk Renew Items -->
<div id="renewModal" class="modal fixed inset-0 modal-overlay z-50 flex items-center justify-center">
    <div class="bg-white rounded-lg shadow-xl w-11/12 md:w-4/5 lg:w-3/4 xl:w-2/3 modal-content">
        <div class="p-6">
            <div class="flex justify-between items-center mb-4">
                <div class="flex items-center space-x-3">
                    <div class="bg-yellow-100 p-2 rounded-full">
                        <i class="fas fa-redo text-yellow-500"></i>
                    </div>
                    <div>
                        <h3 class="text-xl font-semibold text-gray-800">Code Barang Renew</h3>
                        <p class="text-sm text-gray-600">Daftar code barang yang perlu diperbaharui</p>
                    </div>
                </div>
                <button type="button" class="text-gray-500 hover:text-gray-700 text-2xl" onclick="closeModal('renewModal')">
                    <i class="fas fa-times"></i>
                </button>
            </div>
            
            <div class="modal-body">
                <!-- Content will be loaded via AJAX -->
            </div>
        </div>
    </div>
</div>

<style>
/* Additional modal styles */
.modal-body {
    max-height: 60vh;
    overflow-y: auto;
}

.modal-body::-webkit-scrollbar {
    width: 8px;
}

.modal-body::-webkit-scrollbar-track {
    background: #f1f1f1;
    border-radius: 4px;
}

.modal-body::-webkit-scrollbar-thumb {
    background: #c1c1c1;
    border-radius: 4px;
}

.modal-body::-webkit-scrollbar-thumb:hover {
    background: #a8a8a8;
}

.table-container {
    border: 1px solid #e5e7eb;
    border-radius: 8px;
    overflow: hidden;
}

.table-header {
    background: linear-gradient(135deg, #f9fafb 0%, #f3f4f6 100%);
    border-bottom: 2px solid #e5e7eb;
}

.table-row:nth-child(even) {
    background-color: #f9fafb;
}

.table-row:hover {
    background-color: #f3f4f6;
    transition: background-color 0.2s ease;
}

.empty-state {
    text-align: center;
    padding: 2rem;
    color: #6b7280;
}

.empty-state i {
    font-size: 3rem;
    margin-bottom: 1rem;
    opacity: 0.5;
}

.loading-state {
    text-align: center;
    padding: 2rem;
    color: #6b7280;
}

.loading-spinner {
    animation: spin 1s linear infinite;
}

@keyframes spin {
    from { transform: rotate(0deg); }
    to { transform: rotate(360deg); }
}

.info-badge {
    display: inline-flex;
    align-items: center;
    padding: 0.25rem 0.5rem;
    border-radius: 0.375rem;
    font-size: 0.75rem;
    font-weight: 500;
}

.info-badge-blue {
    background-color: #dbeafe;
    color: #1e40af;
}

.info-badge-green {
    background-color: #dcfce7;
    color: #166534;
}

.info-badge-red {
    background-color: #fee2e2;
    color: #dc2626;
}

.info-badge-yellow {
    background-color: #fef3c7;
    color: #d97706;
}

.clickable-row {
    cursor: pointer;
    transition: all 0.2s ease;
}

.clickable-row:hover {
    transform: translateX(2px);
    box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
}

.reservation-link {
    color: #3b82f6;
    font-weight: 600;
    text-decoration: none;
    border-bottom: 1px dotted #3b82f6;
    transition: all 0.2s ease;
}

.reservation-link:hover {
    color: #1d4ed8;
    border-bottom-style: solid;
}

.time-info {
    font-size: 0.75rem;
    color: #6b7280;
    margin-top: 0.25rem;
}

.overdue-highlight {
    border-left: 4px solid #dc2626;
    background: linear-gradient(90deg, #fee2e2 0%, #fef2f2 100%);
}

.status-indicator {
    width: 8px;
    height: 8px;
    border-radius: 50%;
    display: inline-block;
    margin-right: 0.5rem;
}

.status-active {
    background-color: #10b981;
    animation: pulse 2s infinite;
}

.status-overdue {
    background-color: #ef4444;
    animation: pulse 2s infinite;
}

.status-renew {
    background-color: #f59e0b;
}

@keyframes pulse {
    0%, 100% {
        opacity: 1;
    }
    50% {
        opacity: 0.5;
    }
}
</style>