<?php
// Start session
session_start();

// Include database connection
require_once "../config/connection.php";

// Redirect if not borrower user
if (!is_logged_in() || !is_user_type('borrower')) {
    header('HTTP/1.1 403 Forbidden');
    echo json_encode(['error' => 'Unauthorized access']);
    exit();
}

// Validate input
if (!isset($_GET['buyer_id']) || empty($_GET['buyer_id'])) {
    header('HTTP/1.1 400 Bad Request');
    echo json_encode(['error' => 'Buyer ID is required']);
    exit();
}

$buyer_id = intval($_GET['buyer_id']);

// Fetch collection_semarangs for the selected buyer
$stmt = $conn->prepare("SELECT id, nama_collection_semarang FROM collection_semarangs WHERE buyer_id = ?");
$stmt->bind_param("i", $buyer_id);
$stmt->execute();
$result = $stmt->get_result();

$collection_semarangs = [];
while ($row = $result->fetch_assoc()) {
    $collection_semarangs[] = $row;
}

$stmt->close();

// Return collection_semarangs as JSON
header('Content-Type: application/json');
echo json_encode($collection_semarangs);
?>