<!-- header.php -->
<?php
// This file contains the common header and sidebar for Approval pages
// Make sure the user is logged in and has Approval privileges
if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] != 'approval') {
    header("Location: ../login.php");
    exit();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo isset($page_title) ? $page_title . ' | Color Access System' : 'Approval Panel | Color Access System'; ?></title>
    <link rel="icon" href="../images/logo.png" type="image/png">
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        'poppins': ['Poppins', 'sans-serif'],
                    },
                    backgroundImage: {
                        'gradient-primary': 'linear-gradient(135deg, #667eea 0%, #764ba2 100%)',
                        'gradient-side': 'linear-gradient(225deg, #667eea 0%, #764ba2 100%)',
                    },
                    colors: {
                        primary: '#667eea',
                        secondary: '#764ba2',
                        tertiary: '#5a67d8',
                        'light-purple': '#f3e8ff',
                    }
                }
            }
        }
    </script>
    <style>
        /* Additional custom styles */
        .bg-custom-purple {
            background-color: #f3e8ff;
        }
        .main-content-area {
            background-color: #f3e8ff;
        }
        
        /* Signature badge styles */
        .signature-badge {
            display: inline-flex;
            align-items: center;
            padding: 0.25rem 0.75rem;
            border-radius: 9999px;
            font-size: 0.75rem;
            font-weight: 600;
        }
        
        .badge-signed {
            background-color: #10b981;
            color: white;
        }
        
        .badge-pending {
            background-color: #f59e0b;
            color: white;
        }
    </style>
</head>
<body class="font-poppins bg-custom-purple flex h-screen">
    <!-- Sidebar -->
    <div id="sidebar" class="bg-gradient-side text-white w-64 py-4 px-6 flex flex-col transition-all duration-300 h-full shadow-lg fixed lg:relative z-20">
        <div class="flex flex-col items-center mb-6">
            <!-- Logo above Approval Panel text -->
            <div class="relative flex justify-center">
                <div class="rounded-full p-1 bg-white ring-4 ring-white">
                    <img src="../images/logo.png" alt="Logo" class="h-20 w-20 rounded-full object-cover">
                </div>
            </div>
            <h2 class="text-2xl font-bold mt-3">Approval Panel</h2>
            <p class="text-sm text-white/80 mt-1"><?php echo htmlspecialchars($_SESSION['jabatan']); ?></p>
        </div>
        <div class="flex items-center justify-end lg:hidden">
            <button id="closeSidebar" class="text-white">
                <i class="fas fa-times"></i>
            </button>
        </div>

        <div class="flex-1 flex flex-col">
            <!-- Main Menu -->
            <div class="mb-4">
                <div class="text-xs uppercase font-semibold text-white/70 mb-2 pl-2">Main Menu</div>
                <ul>
                    <li class="mb-1">
                        <a href="dashboard_approval.php" class="flex items-center py-2 px-3 rounded-lg hover:bg-white/20 transition-colors duration-200">
                            <i class="fas fa-home w-5"></i>
                            <span class="ml-2">Home</span>
                        </a>
                    </li>
                    <li class="mb-1">
                        <a href="tanda_tangan.php" class="flex items-center py-2 px-3 rounded-lg hover:bg-white/20 transition-colors duration-200">
                            <i class="fas fa-signature w-5"></i>
                            <span class="ml-2">Tanda Tangan</span>
                        </a>
                    </li>
                    <li class="mb-1">
                        <a href="history_tanda_tangan.php" class="flex items-center py-2 px-3 rounded-lg hover:bg-white/20 transition-colors duration-200">
                            <i class="fas fa-history w-5"></i>
                            <span class="ml-2">History Tanda Tangan</span>
                        </a>
                    </li>
                </ul>
            </div>
        </div>
    </div>

    <!-- Main Content -->
    <div class="flex-1 flex flex-col min-h-screen">
        <!-- Top Navigation Bar -->
        <header class="bg-white shadow-sm z-10">
            <div class="flex items-center justify-between px-6 py-3">
                <div class="flex items-center">
                    <button id="toggleSidebar" class="text-gray-600 hover:text-primary lg:hidden">
                        <i class="fas fa-bars text-xl"></i>
                    </button>
                    <h1 class="text-xl font-semibold ml-4 text-gray-800"><?php echo $page_title ?? 'Dashboard'; ?></h1>
                </div>
                
                <!-- User Profile Dropdown -->
                <div class="relative">
                    <button id="profileDropdown" class="flex items-center px-3 py-2 rounded-full bg-gray-100 hover:bg-gray-200 transition-colors duration-200">
                        <div class="flex items-center">
                            <div class="w-8 h-8 rounded-full bg-gradient-primary flex items-center justify-center text-white">
                                <?php echo isset($_SESSION['nama_lengkap']) ? strtoupper(substr($_SESSION['nama_lengkap'], 0, 1)) : 'A'; ?>
                            </div>
                            <div class="ml-2 text-left hidden md:block">
                                <span class="block font-medium text-sm text-gray-700">
                                    <?php echo htmlspecialchars($_SESSION['nama_lengkap'] ?? 'Approval User'); ?>
                                </span>
                                <span class="block text-xs text-gray-500">
                                    <?php echo htmlspecialchars($_SESSION['nik'] ?? ''); ?>
                                </span>
                            </div>
                            <i class="fas fa-chevron-down ml-2 text-xs text-gray-500"></i>
                        </div>
                    </button>
                    
                    <!-- Dropdown Menu -->
                    <div id="profileMenu" class="absolute right-0 mt-2 w-48 bg-white rounded-lg shadow-lg py-2 z-20 hidden">
                        <div class="px-4 py-2 text-sm text-gray-500 border-b border-gray-200">
                            <?php echo htmlspecialchars($_SESSION['jabatan']); ?>
                        </div>
                        <a href="profile_approval.php" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">
                            <i class="fas fa-user mr-2 text-primary"></i> Profile
                        </a>
                        <a href="ubah_password.php" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">
                            <i class="fas fa-key mr-2 text-primary"></i> Ubah Password
                        </a>
                        <div class="border-t border-gray-200 my-1"></div>
                        <a href="../logout.php" class="block px-4 py-2 text-sm text-red-600 hover:bg-gray-100">
                            <i class="fas fa-sign-out-alt mr-2"></i> Logout
                        </a>
                    </div>
                </div>
            </div>
        </header>