<?php

namespace App\Http\Controllers\SuperAdmin;

use App\Http\Controllers\Controller;
use App\Models\ComponentDimension;
use Illuminate\Http\Request;

class ComponentDimensionController extends Controller
{
    /**
     * Display a listing of dimensions with optional type filter
     */
    public function index(Request $request)
    {
        $query = ComponentDimension::query();
        
        // Filter by type if provided
        if ($request->has('type') && $request->type != '') {
            $query->where('type', $request->type);
        }
        
        $dimensions = $query->latest()->paginate(15);
        
        return view('superadmin.dimensions.index', compact('dimensions'));
    }

    /**
     * Show the form for creating a new dimension
     */
    public function create()
    {
        return view('superadmin.dimensions.create');
    }

    /**
     * Store a newly created dimension in storage
     */
    public function store(Request $request)
    {
        $request->validate([
            'value' => 'required|numeric|min:0',
            'type' => 'required|in:lebar,panjang',
        ]);

        ComponentDimension::create($request->all());

        return redirect()->route('superadmin.dimensions.index')->with('success', 'Dimension berhasil ditambahkan!');
    }

    /**
     * Show the form for editing the specified dimension
     */
    public function edit(ComponentDimension $dimension)
    {
        return view('superadmin.dimensions.edit', compact('dimension'));
    }

    /**
     * Update the specified dimension in storage
     */
    public function update(Request $request, ComponentDimension $dimension)
    {
        $request->validate([
            'value' => 'required|numeric|min:0',
            'type' => 'required|in:lebar,panjang',
        ]);

        $dimension->update($request->all());

        return redirect()->route('superadmin.dimensions.index')->with('success', 'Dimension berhasil diupdate!');
    }

    /**
     * Remove the specified dimension from storage
     */
    public function destroy(ComponentDimension $dimension)
    {
        $dimension->delete();
        
        return redirect()->route('superadmin.dimensions.index')->with('success', 'Dimension berhasil dihapus!');
    }
}