<?php

namespace App\Http\Controllers\SuperAdmin;

use App\Http\Controllers\Controller;
use App\Models\OtherComponent;
use Illuminate\Http\Request;

class OtherComponentController extends Controller
{
    public function index()
    {
        $components = OtherComponent::latest()->paginate(10);
        return view('superadmin.components.index', compact('components'));
    }

    public function create()
    {
        return view('superadmin.components.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'material' => 'required|string|max:255',
            'price_per_unit' => 'required|numeric|min:0',
            'unit' => 'required|string|max:20',
            'description' => 'nullable|string',
        ]);

        OtherComponent::create($request->all());

        return redirect()->route('superadmin.components.index')->with('success', 'Component berhasil ditambahkan!');
    }

    public function edit(OtherComponent $component)
    {
        return view('superadmin.components.edit', compact('component'));
    }

    public function update(Request $request, OtherComponent $component)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'material' => 'required|string|max:255',
            'price_per_unit' => 'required|numeric|min:0',
            'unit' => 'required|string|max:20',
            'description' => 'nullable|string',
        ]);

        $component->update($request->all());

        return redirect()->route('superadmin.components.index')->with('success', 'Component berhasil diupdate!');
    }

    public function destroy(OtherComponent $component)
    {
        $component->delete();
        return redirect()->route('superadmin.components.index')->with('success', 'Component berhasil dihapus!');
    }
}