<?php

namespace App\Http\Controllers\SuperAdmin;

use App\Http\Controllers\Controller;
use App\Models\Veneer;
use Illuminate\Http\Request;

class VeneerController extends Controller
{
    public function index()
    {
        $veneers = Veneer::latest()->paginate(10);
        return view('superadmin.veneers.index', compact('veneers'));
    }

    public function create()
    {
        return view('superadmin.veneers.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'thickness' => 'required|numeric|min:0',
            'pattern' => 'required|in:lurus,motif',
            'price_per_m2' => 'required|numeric|min:0',
        ]);

        Veneer::create($request->all());

        return redirect()->route('superadmin.veneers.index')->with('success', 'Veneer berhasil ditambahkan!');
    }

    public function edit(Veneer $veneer)
    {
        return view('superadmin.veneers.edit', compact('veneer'));
    }

    public function update(Request $request, Veneer $veneer)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'thickness' => 'required|numeric|min:0',
            'pattern' => 'required|in:lurus,motif',
            'price_per_m2' => 'required|numeric|min:0',
        ]);

        $veneer->update($request->all());

        return redirect()->route('superadmin.veneers.index')->with('success', 'Veneer berhasil diupdate!');
    }

    public function destroy(Veneer $veneer)
    {
        $veneer->delete();
        return redirect()->route('superadmin.veneers.index')->with('success', 'Veneer berhasil dihapus!');
    }
}