<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Material extends Model
{
    use HasFactory;

    protected $fillable = [
        'category',
        'name',
        'thickness',
        'price_per_m2',
        'price_per_unit',
        'unit',
        'is_active',
    ];

    protected $casts = [
        'thickness' => 'decimal:2',
        'price_per_m2' => 'decimal:2',
        'price_per_unit' => 'decimal:2',
        'is_active' => 'boolean',
    ];
}