<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('materials', function (Blueprint $table) {
            $table->id();
            $table->enum('category', ['panel', 'solid', 'veneer', 'mdf', 'other']);
            $table->string('name'); // PB, PLYWOOD, MAHONI, WALNUT, dll
            $table->decimal('thickness', 8, 2); // Tebal dalam mm
            $table->decimal('price_per_m2', 12, 2)->nullable(); // Harga per M2
            $table->decimal('price_per_unit', 12, 2)->nullable(); // Harga per unit (untuk Cleat, dll)
            $table->string('unit')->default('m2'); // m2, pcs, dll
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('materials');
    }
};