<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('veneers', function (Blueprint $table) {
            $table->id();
            $table->string('name'); // MAHONI, WALNUT, dll
            $table->decimal('thickness', 8, 2); // Tebal 0.5, 0.6, dll
            $table->enum('pattern', ['lurus', 'motif']); // LURUS atau MOTIF
            $table->decimal('price_per_m2', 12, 2); // Harga per M2
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('veneers');
    }
};