<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('other_components', function (Blueprint $table) {
            $table->id();
            $table->string('name'); // Cleat, Support Drawer, Cleat Drawer
            $table->string('material'); // MAHONI, dll
            $table->decimal('price_per_unit', 12, 2); // Harga per unit
            $table->string('unit')->default('pcs'); // pcs, set, dll
            $table->text('description')->nullable();
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('other_components');
    }
};