<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\ComponentDimension;

class ComponentDimensionSeeder extends Seeder
{
    public function run(): void
    {
        $dimensions = [
            // Lebar
            ['value' => 10, 'type' => 'lebar'],
            ['value' => 18, 'type' => 'lebar'],
            ['value' => 40, 'type' => 'lebar'],
            
            // Panjang
            ['value' => 10, 'type' => 'panjang'],
            ['value' => 18, 'type' => 'panjang'],
            ['value' => 40, 'type' => 'panjang'],
        ];

        foreach ($dimensions as $dimension) {
            ComponentDimension::create($dimension);
        }
    }
}