<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Material;

class MaterialSeeder extends Seeder
{
    public function run(): void
    {
        $materials = [
            // PB (Particle Board)
            ['category' => 'panel', 'name' => 'PB', 'thickness' => 15, 'price_per_m2' => 80000, 'unit' => 'm2'],
            ['category' => 'panel', 'name' => 'PB', 'thickness' => 18, 'price_per_m2' => 96000, 'unit' => 'm2'],
            ['category' => 'panel', 'name' => 'PB', 'thickness' => 25, 'price_per_m2' => 138000, 'unit' => 'm2'],
            
            // MDF
            ['category' => 'mdf', 'name' => 'MDF', 'thickness' => 1, 'price_per_m2' => 11000, 'unit' => 'm2'],
            ['category' => 'mdf', 'name' => 'MDF', 'thickness' => 2.5, 'price_per_m2' => 22000, 'unit' => 'm2'],
            ['category' => 'mdf', 'name' => 'MDF', 'thickness' => 4.75, 'price_per_m2' => 38000, 'unit' => 'm2'],
            ['category' => 'mdf', 'name' => 'MDF', 'thickness' => 15, 'price_per_m2' => 107000, 'unit' => 'm2'],
            ['category' => 'mdf', 'name' => 'MDF', 'thickness' => 18, 'price_per_m2' => 128000, 'unit' => 'm2'],
            ['category' => 'mdf', 'name' => 'MDF', 'thickness' => 25, 'price_per_m2' => 210000, 'unit' => 'm2'],
            
            // PLYWOOD
            ['category' => 'panel', 'name' => 'PLYWOOD', 'thickness' => 4.75, 'price_per_m2' => 61000, 'unit' => 'm2'],
            ['category' => 'panel', 'name' => 'PLYWOOD', 'thickness' => 15, 'price_per_m2' => 176000, 'unit' => 'm2'],
            ['category' => 'panel', 'name' => 'PLYWOOD', 'thickness' => 18, 'price_per_m2' => 211000, 'unit' => 'm2'],
            ['category' => 'panel', 'name' => 'PLYWOOD', 'thickness' => 25, 'price_per_m2' => 293000, 'unit' => 'm2'],
            
            // SOLID - MAHONI
            ['category' => 'solid', 'name' => 'MAHONI', 'thickness' => 10, 'price_per_m2' => 133000, 'unit' => 'm2'],
            ['category' => 'solid', 'name' => 'MAHONI', 'thickness' => 18, 'price_per_m2' => 240000, 'unit' => 'm2'],
            ['category' => 'solid', 'name' => 'MAHONI', 'thickness' => 25, 'price_per_m2' => 333000, 'unit' => 'm2'],
            ['category' => 'solid', 'name' => 'MAHONI', 'thickness' => 40, 'price_per_m2' => 532000, 'unit' => 'm2'],
            ['category' => 'solid', 'name' => 'MAHONI', 'thickness' => 50, 'price_per_m2' => 665000, 'unit' => 'm2'],
            
            // SOLID - WALNUT
            ['category' => 'solid', 'name' => 'WALNUT', 'thickness' => 10, 'price_per_m2' => 530000, 'unit' => 'm2'],
            ['category' => 'solid', 'name' => 'WALNUT', 'thickness' => 18, 'price_per_m2' => 954000, 'unit' => 'm2'],
            ['category' => 'solid', 'name' => 'WALNUT', 'thickness' => 25, 'price_per_m2' => 1325000, 'unit' => 'm2'],
            ['category' => 'solid', 'name' => 'WALNUT', 'thickness' => 40, 'price_per_m2' => 2120000, 'unit' => 'm2'],
            ['category' => 'solid', 'name' => 'WALNUT', 'thickness' => 50, 'price_per_m2' => 2650000, 'unit' => 'm2'],
        ];

        foreach ($materials as $material) {
            Material::create($material);
        }
    }
}